Google released a new report showing more than thirty percent of global Gmail traffic becomes unencrypted at some point in transit between the email sender and its recipient. In order to remedy this, Google has developed, and is in the process of making public, a tool that will encrypt all data traveling out of its Chrome Browser for any user who has installed its End-to-End extension.
You may find this confusing given that Gmail transmits data over a securely encrypted HTTPS connection all the time, suggesting that 100 percent of outbound traffic should be encrypted. The reality though, is that HTTPS merely means that your data is encrypted from your computer, through your browser, and onto Google’s servers.
As you may recall, until a few months ago, Google was not encrypting the links between servers in their own data centers. This ended up being a vulnerability that was allegedly exploited by the United States National Security Agency in order to perform surveillance operations. This caused more than a bit of outrage and Google responded by encrypting these connections.
.@Google's new tool will encrypt all data traveling out of its #Chrome browser. #CryptoTweet. If you are communicating Gmail-to-Gmail, then you should be encrypted all the time. These data reflect encryption in transit, and unfortunately, some companies aren’t as concerned about privacy and security as Google is.
In all, the company says 69 percent of outbound email from Gmail is encrypted, and 48 percent of mail inbound to Gmail is encrypted. Specifically, in the Americas, fewer than one in 10,000 emails from Gmail are decrypted by AOL, which is very good. On the other hand, AT&T decrypts half of such emails. Comcast does not encrypt emails from Google at all. On the other side, Facebook and Amazon encrypt nearly all the email they send to Gmail, while the email marketing service Constant Contact encrypts amost nothing it sends to Gmail.
The aim of this End-to-End new tool is to put simple and easy to use encryption tools in the hands of everyday users. In this way, the user can ensure his or her data is encrypted in transit. There is certainly no shortage of existing encryption tools on the market at the moment. However, many of these tools are complicated and difficult to use.
“While end-to-end encryption tools like PGP and GnuPG have been around for a long time, they require a great deal of technical know-how and manual effort to use,” wrote Stephan Somogyi, product manager, security and privacy at Google. “To help make this kind of encryption a bit easier, we’re releasing code for a new Chrome extension that uses OpenPGP, an open standard supported by many existing encryption tools.”
In all, the encryption data illustrates the volume of encrypted data flowing in and out of Google’s Gmail service, including information about which other providers encrypt Gmail data as it passes through their own servers.
“Encryption with Transport Layer Security keeps prying eyes away from your messages while they’re in transit,” Google explains. “TLS is a protocol that encrypts and delivers mail securely, for both inbound and outbound mail traffic. It helps prevent eavesdropping between mail servers – keeping your messages private while they’re moving between email providers.”
However, they go on to explain, the contents of your communications are encrypted only if you and the people you email with both use email providers that support TLS, which not every provider does.
“TLS is being adopted as the standard for secure email. While it’s not a perfect solution, if everyone uses it, snooping on email will be more difficult and costly than it is today.”
In a perfect world, every email service provider would encrypt user communications from the sender to the recipient and everywhere in between – or, as we say in the industry, from end-to-end.