Blood pressure is the force of your blood pushing against the walls of your arteries as your heart pumps blood to your body.
Blood pressure readings are given as 2 numbers. The top number is called the systolic pressure. It is the highest pressure in the blood vessels when the heart is pumping. The bottom number is called the diastolic pressure. It is the lowest pressure in the blood vessels when the heart is resting between beats.
Blood pressure is usually written like this: 140/90. You may hear it said as “140 over 90.”
Blood pressure ranges are:
- 119/79 or lower is normal blood pressure
- 120/80 to 139/89 is prehypertension
- 140/90 or higher is high blood pressure
Prehypertension means that you may develop high blood pressure but you can prevent it with healthy lifestyle changes.
High blood pressure, also called hypertension, that stays high over time can lead to serious problems including:
- Stroke
- Heart failure
- Heart attack
- Kidney failure
High Blood Pressure Risk Factors
Blood pressure changes from minute to minute. Age, time of day, exercise, smoking, emotions, pain and medicines are just a few of the things that can cause blood pressure to change.
Many times we don’t know what causes high blood pressure. We call this type of high blood pressure, essential hypertension.
Secondary hypertension is high blood pressure caused by things such as:
- Being overweight or obese
- Smoking
- Lack of exercise
- Eating too much salt in your diet
- Not having enough potassium in your diet
- Drinking too much alcohol
- Stress
- Ethnic background: high blood pressure is more common in African-Americans
- Family history of high blood pressure
High Blood Pressure Symptoms
You can have high blood pressure for years without knowing it, because it usually has no signs or symptoms. Rarely, symptoms occur only in people in hypertensive crisis (extremely high blood pressure of higher than 180/110). These symptoms include:
- Severe headache
- Fatigue or confusion
- Vision problems
- Chest pain
- Difficulty breathing
- Irregular heartbeat
- Blood in the urine
- Pounding in your chest, neck or ears
The best way to find out whether you have high blood pressure is to have it checked at least every 2 years, starting at age 18, as part of your routine checkup.
High Blood Pressure Diagnosis
Your physician may detect your high blood pressure during your regular checkups. At Wake Forest Baptist, we perform further testing to find the causes of your high blood pressure and to check for possible organ damage. Among the tests your physician may recommend are:
- Blood and urine tests for cholesterol and hormones
- CT
- Echocardiogram
- Chest X-ray
- Electrocardiogram (EKG)
- Vascular ultrasound
Managing High Blood Pressure
Most of the time, high blood pressure can be controlled with blood pressure medicine and some changes in lifestyle. We will work with you to get you on the right track with a plan of action to keep you healthy. We may recommend:
- Medications
- Regular exercise
- Healthy diet
- Quitting smoking
- Limiting alcohol
- Reducing sodium (salt) in your diet
- Lowering stress
- Maintaining a healthy body weight