Mood Disorders: How to Recognize and Treat Them
Could You Have A Mood Disorder?
If your emotions and moods seem out of your control over a long period of time, you may have a mood disorder. There are several different types, and all of them can be treated.
Bipolar Disorder
This causes extreme mood swings, from depression to emotional highs called mania. During the highs, you have more energy and your thoughts may come quickly -- you may be unusually talkative. You might get a lot of things done, but also might behave in unpredictable, unhealthy ways. These mood shifts can happen only a few times a year or as often as several times a week.
Treatment
You may need to see a psychiatrist, who can prescribe medication, along with a psychologist, who focuses on talk therapy to help you deal with problems at work or family tension. Antidepressants, antipsychotics, anti-anxiety medications, and mood stabilizers can treat bipolar disorder. In severe cases, electroconvulsive therapy -- when electric current is passed through your brain -- helps some people.
Major Depressive Disorder
This is also called clinical depression, or simply depression. It’s more than having “the blues” -- it’s long periods of extreme sadness that keep coming back. You may get angry or frustrated easily, or lose interest in things you used to enjoy. Small tasks may seem overwhelming, and you may feel empty, hopeless, tired, and distracted. You also may have trouble with sleeping -- either too much or too little. Some people with major depressive disorder could have some minor manic symptoms but not often enough to call their condition bipolar disorder.
Treatment
Your doctor may suggest that you speak with a trained mental health professional (a therapist). This is called talk therapy or psychotherapy. You may talk with someone one-on-one, or go to group sessions with other people who have the same condition. Your doctor may also give you medication to help your mood, especially if your symptoms are severe.
Persistent Depressive Disorder (PDD)
This is a form of major depressive disorder where symptoms last at least 2 years. It combines two former types of depression that had been called dysthymic disorder and chronic major depression.
Treatment
Talk therapy may help with PDD, too. For example, with cognitive behavior therapy, you learn about your condition and do things to help you understand and change your thoughts and behavior. That might include reflection, meditation, and journaling. Medications can help with PDD as well.
Seasonal Affective Disorder (SAD)
This may feel a lot like major depressive disorder, but the symptoms are brought on by the change of seasons: It begins and ends about the same time every year. It’s most likely to start in fall, continue into winter, and not end until spring. As with other kinds of depression, you may have less energy, feel moody and anxious, and have trouble sleeping.
Treatment
Talk therapy or antidepressants may help, and your doctor also might suggest light therapy. That’s when you sit or work near a bright light that’s similar to natural outdoor light.
Premenstrual Dysphoric Disorder (PMDD)
This is like premenstrual syndrome (PMS) but worse. You might feel sadness, anxiety, irritability, and extreme moodiness in the 7 to 10 days before your period. Doctors aren’t sure why some women are affected by this, but it can be linked to depression and anxiety. Only a doctor can tell you for sure if you have PMDD.
Treatment
It can help to exercise, stay away from caffeine and alcohol, and eat a healthy diet. Nutritional supplements like vitamin B6 and magnesium may also help, but talk to your doctor first. In severe cases, your doctor may give you antidepressants to take all the time or just between the time you ovulate and have your period.
Depressive Disorder Due to a Medical Condition
Depression, or symptoms of it, are often linked to serious health problems that can affect your mood, such as thyroid disease, some kinds of infections, or brain conditions like Huntington's disease or Parkinson's disease.
Treatment
Your doctor will treat the medical problem that’s causing it, but you also may need medication or talk therapy for your depression as well.
Up Next
Next Slideshow Title
Sources | Medically Reviewed on 12/19/2018 Reviewed by Smitha Bhandari, MD on December 19, 2018
SOURCES:
Mayo Clinic: “Light Therapy,” “Persistent depressive disorder (dysthymia),” “Depression (major depressive disorder),” “Bipolar disorder,” “Seasonal affective disorder (SAD),” “PMS: What's the difference between premenstrual dysphoric disorder (PMDD) and premenstrual syndrome (PMS)? How is PMDD treated?” “Diseases and Conditions: Mood disorders.”
National Institutes of Health: “Identifying and Managing Depression in the Medical Patient.”
Reviewed by Smitha Bhandari, MD on December?