[Date Index]
[Thread Index]
[Author Index]
Re: Simple Recursive Map
You program it essentially the way you said it, just converting to
Mathematica notation for everything and using n on the left-hand sides
of the recurrence relations instead of n + 1:
Clear[x, y]
x[n_] := x[n] = y[n - 1] - a x[n - 1]^2 - 1
y[n_] := y[n] = b x[n - 1]
x[0] = 1.; y[0] = -1.; a = 0.02; b = 1/3.;
{x[49], y[49]}
{-1.57436, -0.524786}
Notice the (highly recommended) use of "caching" the values -- the
subexpressions x[n_] := x[n] = and similarly for y -- in the recurrence
relations in order to speed up the calculations. Without that,
Mathematica doesn't "remember" the values of x and y when it calculates
them and has to re-calculate them for each subsequent evaluation.
Reuben wrote:
>
>