Job Descriptions Basics
What Is A Job Description?
A job description is a written statement that describes the main objective of a job, its essential and nonessential functions, the qualifications, and other information.
A job description may describe duties, skills, effort, and responsibilities, environmental and working conditions, and the education and experience required. It also may include information on tools and equipment used and relationships with other jobs.
Thirty people may hold the same job and, therefore, use the same job description. It is important to remember that a job description describes the job, not the person or persons who hold that job.
There are two basic types of job descriptions: “generic” or general and “specific” or individual. In addition, position descriptions often are written for individual, high-level managerial employees.
Specific Or Generic?
The specific job description provides information on all the essential duties and responsibilities assigned to one or more individuals performing the job. It is usually quite detailed and comprehensive and provides a sound basis for job evaluation, training, orientation, and human resources/personnel organizational planning. This type of description demands a thorough job analysis, considerable care and expertise in preparation, and an effort to keep it useful and up to date. It is the soundest type of job description to use, and usually the most expensive to prepare. There is also a tendency to exclude incidental responsibilities and duties, and disagreements can arise between supervisors and employees when relatively minor job duties change.
Generic job descriptions, on the other hand, are written in broadly stated, general terms without identifying specific functions, tasks, and responsibilities. A generic description is applicable to a group of similar or near-similar jobs, and therefore the per-job cost of preparation is lower. However, since the description must be written broadly enough to allow for some variations in product, equipment and materials used, or procedures, it may include some functions performed in one or more of the jobs but not all of them.
Today, because of the Americans with Disabilities Act (ADA), use of the generic job description is not recommended. While the ADA doesn’t require job descriptions, it does require that applicants and employees be able to perform the “essential functions” of the job, with or without reasonable accommodation. However, the EEOC has said that one of the things it will look at when determining essential functions the supervisor chooses to ignore the limitations built into the description.
No job description should be viewed as a perfect reflection of the job. The object of a good job description is to differentiate the job (or group of jobs) from other jobs and to set outer limits.
The information for much of the job description often is obtained a job analysis. The purpose is to identify the job, define it within established parameters, and describe its scope and content. The job analysis should be accurate, concise, and complete.
Job descriptions, and the process used to develop them, should conform to all legal requirements. One key law to keep in mind is the ADA, which took effect for many employers in July 1992. Again, while this law does not specifically require the use of job descriptions, it has great ramifications on their use. Other laws that affect job descriptions are discussed in detail in the section, The Job Description in the Organization.
Why Are Job Descriptions Important?
Job descriptions are important for a number of reasons:
- They clarify who is responsible for what within the company. They also help define relationships between individuals, between departments, etc. When used to advantage, they can help to settle grievances, minimize conflicts, and improve communications.
- Job descriptions help the jobholder understand the responsibilities of the position. This not only enables the employee to assess the relative importance of everything he or she is accountable for, but also provides a sense of where the job fits into the company as a whole.
- Job descriptions are helpful to applicants, employees, supervisors, and human resources professionals at every stage in the employment relationship, from recruitment to retirement. They provide information about the knowledge, raining, education, and skills needed for each job. They prevent misunderstandings by telling employees what they need to know about their jobs. Best of all, they provide this information in a completely objective and impersonal way.
- Job descriptions help management analyze and improve the company’s structure. They reveal whether all company responsibilities are adequately covered and where these responsibilities should be reallocated to achieve a better balance.
- Accurate job descriptions provide a basis for job evaluation, wage and salary surveys, and an equitable wage and salary structure.
Finally, they provide a basis from which to determine whether a disabled applicant is otherwise qualified for the job and, if so, what accommodation should be made to let the applicant perform the essential functions of the position.
So Many Jobs, So Little Time: The Bane
Despite these and other benefits, job descriptions traditionally have suffered a poor reputation among managers and human resources staffers. In fact, job descriptions often end up being ignored. “Job descriptions? Sure, we have them. They’re in the bottom drawer of that file cabinet with the big stack of books in front of it.
Why? There are a number of reasons. It takes commitment to maintain a job description program. It means that someone must be vested with that responsibility, i.e., it’s got to be part of someone’s job description. In addition, supervisors and managers must take time to participate in maintaining job descriptions.
More important, however, people forget just how important job descriptions are as preventive medicine. People forget to floss their teeth until they begin to have gum problems. In just the same way, people forget to maintain job descriptions until six months after an incumbent has left the job and the new person isn’t doing what the boss wants. Then it becomes a crisis, and it takes a lot more effort to figure out whether the problem is a job performance problem, a personality clash between supervisor and subordinate, or simply that the new person never was told clearly what the job entailed.
Doing It Right The First Time
Yet, one of the most common reasons a job description isn’t used is because it isn’t useful. In other words, it lacks validity, and therefore it fails to achieve its potential.
A job description is valid to the extent that it accurately reflects job content. An out-of-date job description obviously is not valid. But even descriptions written yesterday can suffer from a lack of validity.; and employees may end up struggling to achieve unrealistic standards of performance. And this is only the tip of the iceberg!
The typical job description is often deficient in at least one of the following ways:
- The description exaggerates or downplays the importance of the job.
- It fails to pinpoint the critical elements that differentiate between successful and unsuccessful job performance.
- It ignores the decision-making aspects of the job.
- It either fails to focus on the job incumbent’s actual behavior or it defines required behavior in ambiguous terms.
- secretary for the position described. Would you have enough information about the job to feel confident about what was expected of you and about your ability to meet the job’s performance standards?
Write a comment: