What’s new about Xi’s “new era” of China-Latin America Relations?
By now, we should be accustomed to annual, high-level visits and summits involving top Chinese officials and Latin American leaders at which ambitious trade, investment and financial targets and deals are announced. Yet this year official Chinese media outlets are keen to stress that Xi’s visit – which begins today and takes in Chile, Ecuador and Peru over seven days around the APEC summit in Lima – will “usher in a new era” of China-Latin America relations. What should we make of renewed talk of a new period in China’s relations with Latin America and, in particular, what might this mean for the highly prized extractive and infrastructure ties between China and resource-rich South American countries?
To begin, Chinese officials’ emphasis on a new era of relations with Latin America should be understood in the context of the end of the commodity boom. Depending on the commodity, the boom has now been over for at least two (oil) or three (iron ore) years or even longer (copper). The push by Chinese leaders and diplomats for a new phase of relations, especially with commodity-rich South America, is a belated response to the reality of dramatic drops in the demand and price for raw material exports from South America. This phenomenon is closely linked to changes in China’s own economy, which is switching towards a model of internal consumption.
Yet even if official recognition of the end of the ‘boom’ phase of relations is playing catch-up with reality, Chinese officials, including premier Li Keqiang and Xi Jinping, have on recent visits in 2015 and 2014, respectively, emphasised that commercial relations should increasingly involve the expansion of trade beyond raw materials. Such discussions usually center on greater Chinese investment and financing in Latin American infrastructure and manufacturing. Similar themes will certainly be a focus of Xi’s upcoming visit, and given that he’s attending APEC, a trans-Pacific regional trade forum, not to mention two founding members of the TPP in Chile and Peru just as the US seems set to abandon TPP, Xi may almost certainly promote alternative Chinese trade plans.
Any discussion of a “new era” of China-Latin America (in this case, South America) relations must take into account this new context. On the South American side, the boom itself certainly increased anxieties about a return to historical patterns of commodity dependency and increased environmental stresses. The hangover from the bust, especially in countries like Venezuela, has been harsh. For Chinese buyers and investors on the other hand, the end of the boom largely means a dramatically reduced import bill and possible fire-sale deals on South American energy, mining and agricultural assets. Hype about the “win-win” potential of the China-Latin America relationship hit vertiginous levels at the inaugural China-CELAC ministerial forum almost two years ago. The current context is a more sober one and we’re unlikely to see the same levels again.
China’s proposed alternative drivers of economic ties, including transportation and energy infrastructure investment and financing as well as the “export of industrial capacity” from China to Latin America, are part of a Chinese agenda designed to promote Chinese interests. Of course, government officials and Party media in China have emphasised that such plans are part of an effort to “promote common development and build a community of shared destiny between China and Latin America”, yet the real question for Latin American countries both during this visit and in the years ahead is how, in their ties with China, to more effectively promote their own development principles and interests in a post-commodity boom environment.
Infrastructure and extractive industries will almost certainly continue to be at the heart of China-Latin America relations and are a perfect starting point for a reinvigorated discussion with China about what would constitute a more economically and environmentally sustainable relationship – one that best accords with Latin American countries’ and citizens’ own development visions. Such discussions would benefit greatly from a less parochial and more comparative perspective than has largely been the case until now.
Especially on such issues as environmental and social protocols, including engagement with local communities and non-government organisations, tied to Chinese investments in mining, energy and dam projects, South America shares much in common with certain countries in Southeast Asia and Africa. Myanmar is a perfect case in point. Dam, oil and gas pipeline, and copper mine projects have all been the subject of contention, but also dialogue and engagement between Chinese officials, company executives and local communities and the government.
In turn, governments and citizens in Southeast Asian and African countries who share similar types of relationships and challenges in their ties with China could learn from South American experiences, including in lessons about the benefits and costs of state-to-state and resourced-backed lending. And if China is truly interested in forging a new era of relations with Latin America, but also with other developing countries in places like Africa, Southeast Asia and elsewhere, it would also do well to extend the lessons of experiences in each of these regions more broadly.
For the countries on Xi’s latest overseas itinerary, especially Peru and Ecuador where Chinese investment in mining, oil and dam projects has been significant, it not only makes sense to look to engage China on issues and standards that are emerging from China’s ties to other regions, but also on development initiatives that China is sponsoring in its own neighborhood. Not only are Chinese government and company officials experimenting with new approaches and standards for corporate social responsibility, environmental impact assessments and better political risk analysis in places like Cambodia and Myanmar, but some are also seeking to embed such practices in new institutions like the Asian Infrastructure Investment Bank (AIIB).
For Latin American governments, academics and citizens, learning more about such approaches, experiments and standards and seeking to ensure that they are also extended as best practice in investments and project finance, and to such new institutions as the New Development (or BRICS) Bank, would certainly mark the beginning of a regional strategy for a new era of ties with China.