Harmful Algal Blooms
A harmful algal bloom (HAB) is a buildup of blue-green algae that creates a green, blue-green, white or brown coloring on the surface of ponds, lakes and other slow-moving waterways, sometimes occurring as mats or scum.
Blooms are most common between June and September. They grow in warm, stagnant and nutrient-rich water, and are becoming increasingly common both in California and nationwide.
Human exposure to water containing toxic harmful algal blooms, for example by direct body contact or ingestion, can result in a number of symptoms including the following:
- Rashes
- Eye, nose, mouth or throat irritation
- Allergic reactions
- Headache
- Gastrointestinal upset, such as abdominal pain, nausea, vomiting and diarrhea
Discovery Bay Information
June 11, 2020
The Regional Water Quality Control Board (RWCQB) did water sampling in Discovery Bay on June 4, 2020. The laboratory results are in, and unfortunately, harmful algal blooms (HAB) are present and the cyanotoxins these produce were found at DANGER levels. It is recommended that people and pets avoid contact with the water, and that fish or shellfish caught in these waters not be eaten. It is recommended that tenants of rental units also be notified.
For More Information Please Visit:
Other sites in Contra Costa County have experienced harmful algal blooms
- Big Break Regional Shoreline (Oakley)
- Tilden Park (Lake Anza)
- Pittsburg Yacht Harbor In response to a complaint, Environmental Health sampled the water at the Pittsburg Yacht Harbor on July 24, 2018. The results for that area showed microcystins well above the Danger level. The lab results and recommended signage were provided to the City of Pittsburg. Lab Results
FAQs
Is it safe for me to go in the water? the water for drinking or cooking
- Do not let pets or livestock go into or drink the water, or go near the scum on the shoreline
- Do not eat shellfish from the water
- on shore
- Do not eat fish or shellfish from the water
- Do not use the water for drinking or cooking. Boiling or filtering will not make the water safe
Exposure to HAB can cause rashes, skin and eye irritation, allergic reactions, gastrointestinal upset and other effects. At high concentrations, exposure can result in serious illness or death. For more information, see California Water Quality Monitoring Council HAB Portal.
What about my pets?
Keep pets out of water with harmful algal blooms. Dogs are especially vulnerable to getting sick and there have been reports of dogs dying following exposure associated with drinking the water or licking algae from their fur after wading or swimming in water with blooms.
Who should I contact if I swam in the water and now have symptoms?
If you think you or someone else is displaying symptoms of HAB poisoning, contact your healthcare provider or the California Poison Center Help Hotline at 1-800-222-1222.
What can I do to get rid of harmful algae?
We do not recommend attempting to treat or remove the algae. Harmful algae blooms are part of the environment's food chain and eventually dissipate on their own. Chemical treatment is often ineffective and can result in more toxins being released into the water when the algae cells die, and can have unintended effects on other species.
Algal. Minimize the use of fertilizers whenever possible.
Do I neeed to wash my boat after it has been in HAB infested waters?
There are no specific actions regarding boats that have been in bloom-infested waters, but the Division of Boating & Waterways has guidance on preventing invasive species: Clean, Drain, and Dry Boat Cleaning Procedures
Pets & Vets
Keep pets out of water with harmful algae blooms. Dogs are especially vulnerable to getting sick and there have been reports of dogs dying following exposure associated with drinking the water or licking algae from their fur.
Documents
Other Links
How to Avoid Toxic Exposure
- Always assume that a algal bloom is toxic
- Do not swim and avoid jet-skiing, wind surfing or water skiing in water with scum layers or blooms
- Do not allow children or pets to swim in water with scum layers or blooms
- Do not drink or use water containing algae. Boiling will not remove algal toxins
- Do not eat fish or shellfish caught or harvested in a bloom area
- Respect any water-body closures by public health authorities
What to Do When Exposed?
- If you come into contact with a bloom, wash your skin and hair thoroughly. If wearing a swimsuit, pay careful attention to skin under the swimsuit
- If your pet comes into contact with a bloom, wash it thoroughly with clean water to prevent algae ingestion while your pet cleans itself. If you believe your pet may have ingested dry or liquid algae contact a licensed veterinarian right away
- If you ingest algae or suspect that you may have and begin to experience symptoms, contact your healthcare provider or California Poison Control 1-800-222-1222
Resources
Documents
- Harmful Algal Blooms (HABs)
- What you need to know about Blue-Green Algae
- Cyanobacteria Blooms FAQs - CDC
- Caution Advisory
- Warning Advisory
- Danger Advisory
- HAB microcystin Threshold Levels
- Blue-Green Algae: A Veterinarian Reference
- Notice to California Veterinarians
- YouTube: Informational video on HAB from the Department of Water Resources
Signage
Other Links
- California Water Quality Monitoring Council HAB Portal
- Frequently Asked Questions about Freshwater and Estuarine Harmful Algal Blooms
- CA Office of Environmental Health Hazard Assessment: Information on Microcystin
- EPA HAB Information
Lab Results
The following are the lab results for water samples taken by Environmental Health.