Energizing Livelihoods
It began with the maturing realization that policies affecting Energy Access transcend beyond the Ministries focused on Power or Renewable Energy. For tangible socio-economic benefits to flow, energy solutions need to be integrated into broader development plans in livelihoods, education, and health –among others-. Compartmentalizing development policies is counter-productive to the philosophy of creating holistic solutions and building the ecosystem for energy services.
With this in mind, in May 2013, the Policy group embarked on an exercise to identify the energy needs of various development-oriented ministries and determine ways in which decentralized renewable energy solutions could promote their growth agenda. Given the practitioner experience in bridging the energy gap in rural development, we chose to start with the National Rural Livelihood Mission (NRLM) of the Ministry of Rural Development. This mission that the Government of India launched in 2011 seeks to use grassroots level institutions to bring about improvements in livelihoods, including self-employment and skilled employment. The Mission has been critical in providing an impetus to the promotion of rural livelihoods through the formation of Self-Help Groups (SHGs) and credit linkages for them. However, ground realities suggest that energy access, an important part of livelihood improvement, is often assumed to be available and reliable.
Our work in Energizing Livelihoods is an effort to emphasize on integrating energy interventions into planning at an early stage. To begin, we identified a set of energy interventions suitable the value chain of specific livelihood categories. One of our interns, Natacha, put together a table summarizing these interventions, provided below:
In addition to looking at interventions with existing livelihoods, there has also been a focus on showing how energy access can be a livelihood in itself. The ecosystem essential for such decentralized, renewable, energy-based entrepreneurship has been outlined (depicted below), with different entities being responsible for aspects such as technology, finance and capacity building.
The approach was of interest to certain individuals within NRLM. To capitalize on this interest, the Policy Group supported the creation of a concept note to outline how SHGs created in each State could look at decentralized energy entrepreneurship as a livelihood possibility. The role of different entities and the possibilities for SHGs to be Operators, Entrepreneurs or Franchisees of existing entrepreneurs was explored through this note. The SHG as an Operator or Entrepreneur of the Integrated Energy Center provides immediate energy access facilities for Households in the area- including Lighting, Mobile charging, Television, and Refrigeration. The SHG could also use the Energy Center to meet the energy requirements for the specific livelihood of its own members (Eg: Sewing machines, Agarbatti making machines, Leaf plate stitching etc.).
Financial Support:
The initial amount required to meet the Capital costs of the Energy Center to be run/owned by SHGs. It may be through one of the Partners (detailed below) and in the form of a Loan/ Grant/ Subsidized capital cost. Partners:
Technology and Knowledge partner: Practitioners in the sphere of decentralized energy access, undertaking installation, maintenance and training for SHGs
State Rural Livelihood Promotion Society: Programme partner or Ground partner connecting other entities to the Self Help Groups (SHGs)
MNRE/ SNA: Supporting and overseeing the technology partner’s work on the ground; facilitating access to subsidies and fiscal incentives that could accrue.
Local Bank: Particularly important in an Entrepreneurial model where SHG can access loan through this entity to set up the Energy Center.
Operators/ Entrepreneurs/ Franchisees
In this case, the Self Help Groups (SHGs) maintain the entire center on a day-to-day basis, using it for their own needs as well as meeting the energy needs of the community
The plan is to attempt to identify a 5-10 SHGs across a few states and begin pilot projects with them. This will include a needs assessment of the current livelihoods of SHG members, the energy needs of their communities and the energy interventions that would be relevant. The next step would be to connect with the local vocational training institute to support with training and capitalize on the existing credit linkage of the SHG to undertake this initiative. The final piece would be the support of existing energy solution enterprises to provide technology.
Independent of the NRLM or other Government programmes, versions of such a model have been tried and tested through local individuals/entrepreneurs in parts of Bihar, Karnataka and Meghalaya. We have received a positive response from the Rural Livelihood Promotion Society in Karnataka about taking this initiative forward with a few individuals or Joint Liability Groups through affiliated NGOs and Self Employment training institutes.
The real change lies in being able to showcase the learnings from 1-2 States and advocate using the National level mission for the model to be pursued by other State level rural livelihood promotion entities. This would go a long way in being able to promote grassroots level energy entrepreneurship while simultaneously opening up the possibility for energy to be seen as part of an integrated approach to Government planning.