Let. Given that the web is indeed global, then anyone from London to Lahore can view your carefully crafted web pages – and if you want to appeal to a global audience, it may be best to design your site so that it’s easier to convert for international visitors.
Arabic, for example, has around 300 million native speakers around the globe, and as an official language in 26 countries (the third most after English and French), it’s clear that Arabic is a language that shouldn’t be ignored for those seeking to make serious inroads into international markets.
Using Unicode
Fancy graphics and cool colour schemes will certainly help sell your site to the masses – but ultimately, the old adage that content is king certainly rings true for most websites.
With that in mind, even if the plan is to build your website in English only, if you design using Unicode from the start, you will be well positioned to adapt your pages for other languages later on. Unicode is the only sensible character-set option that enables websites to support different scripts. UTF-8 is compatible with over 90 written languages (‘scripts’) and has a range of over a hundred thousand different characters.
Importantly, UTF-8 is supported by the most common browsers (Explorer, FireFox etc) and Operating Systems (Windows, Linux, MacOs), whilst the likes of Apple, Microsoft, IBM and other industry lynchpins have all adopted it as a standard.
Even if you don’t plan to use a non-Latin script on your site such as Arabic, the German alphabet, for example, contains an additional four characters: Ä, Ö, Ü and ß. Many other European alphabet systems use even more characters – which is why using Unicode is important.
Green Hats: Cultural and Colour Considerations
If you are setting up a website primarily to be aimed at audiences in the US or the UK, that’s great. But what if your strategy changes later on? It’s much easier to develop the aesthetics of your site from the start, rather than re-designing it later on.
Clearly, you can’t structure the aesthetics of your website to please everyone. But you can choose a culturally sensitive colour scheme – remember that different colours can mean different things in different cultures.
For example, in the United Arab Emirates and other Arabic cultures, green signifies holiness or luck, whilst blue represents immortality and is deemed a ‘protective’ colour. Orange has religious connotations for Protestants in Northern Ireland, and whatever you do, you might want to avoid placing a green hat anywhere on your website, as this means that a man’s wife has been unfaithful to him in China.
A light-coloured background with dark text is a safe bet across the world – it’s easy to read. Any other graphics, patterns or colour schemes you use should be chosen to reflect any markets you plan to enter: as a general rule of thumb, it’s best to avoid anything that is potentially divisive, such as religious, political or sexual symbols. A picture of a partially clad lady may go down a storm in the West, but in many eastern cultures, a dim view may be taken of this.
Layout & Navigation
Not all languages read from left to right. Arabic is one such language that reads in the opposite direction (right-to-left) and as such, this can throw up some issues when converting your design for specific markets.
If your navigation bar is vertically positioned on the left-hand-side of your English language website, then in Arabic users will obviously have to read from the right to left which means the navigation bar may not appear in your preferred position in relation to the direction the user is reading.
Of course, it’s not the end of the world if you have to shift the navigation bar to the other side of the page for your Arabic site, but for simplicity – and uniformity – you may favour a horizontally positioned navigation bar instead. This means the rest of your design and layout templates can remain the same across all your sites.
Bandwidth Barriers
This may be hard to believe, but not all countries have high-speed broadband internet access yet. Much of South America, Africa and even parts of Asia are still on internet connections that most people in Western countries would deem ‘slow’. With that in mind, you may want to avoid really heavy graphics and bandwidth-sapping Flash animations – it’s unlikely web users will hang around for ten minutes for a picture to load on their screen.
This doesn’t mean you should build text-only websites, but it does mean you should perhaps provide two options for web users: a simple HTML only version and a normal, flashy ‘bells and whistles’ version.
Multilingual SEO
You might have the most beautifully designed website in the world, but if nobody can find it on the World Wide Web, then is there any point in it being there?
Visibility is everything on the internet, which is why search engine optimisation (SEO) plays such a crucial part of any web content strategy. The issue of SEO is probably best left for another article, but for those who already optimise their English language site, it’s worth bearing in mind one golden rule of thumb when optimising your site for international markets: never translate your keywords directly.
If you’re translating your website content yourself or using a translation agency, the keywords for which you rank highly on Google.com or Google.co.uk should be researched for each target country. A translator won’t know what people use to search for products or services locally, they may use synonyms, abbreviations or colloquialisms.
And there you have it…the basics of multicultural web design!