In less than 40 years, Guangzhou-based China Southern Airlines has grown into a global juggernaut. With a fleet of over 600 planes, including a handful of high-profile A380s, China Southern Airlines now has a presence at major airports worldwide. It marks a meteoric rise for the once-obscure Chinese airline.
China Southern Airlines has its origins in the breakup of CAAC Airlines in the 1980s. The Civil Aviation Administration of China had operated a monopoly airline in China. But the Chinese Government elected to decentralize the CAAC. As a result, CAAC Airlines was wound up. A freshly decentralized CAAC divided China into seven regions, including the Guangzhou Regional Administration.
Guangzhou-based China Southern Airlines began flying under its own brand and colors in early 1991. Elsewhere around China, now well-known airlines like China Eastern and Air China also got their start around this time.
The heady early years at China Southern Airlines
In China Southern’s early days, the airline was largely restricted to flying within China and the immediate Asian region. Rival Air China was the designated national carrier and was handed the choicest long-haul routes.
While China Southern Airlines had a big slice of the domestic market, it also had long-haul ambitions. The airline was flying under the China Southern brand and colors by 1991, but it took another two years to gain “independence” from the CAAC.
By then, China Southern was working with foreign airlines to lift standards and overcome the then dubious reputation of Chinese carriers. In 1996, the airline began its first long-haul route, flying between Guangzhou and Amsterdam via Beijing. In 1997, China Southern started flying to Los Angeles, breaking into the all-important North American market.
China Southern’s breakout flights coincided with changes happening in China. Standards of living were rising fast, and the Chinese Government adopted a more outward-looking stance. With the Chinese people becoming more mobile, it was a good time to be a Chinese carrier.
Modernization and consolidations benefit China Southern Airlines
As China Southern eyed extending its network, it needed new planes. China Southern needed bigger planes capable of flying longer distances than their domestic workhorse aircraft. The airline also needed snappy new planes to help overcome the reputational issues hindering Chinese carriers.
Less than 18 months after first flying under the China Southern brand, the airline placed a US$800 million order for six Boeing 777-200s, with the first due for delivery in 1995. By the mid-1990s, China Southern had less than 100 planes in its fleet, a far cry from today’s 600 plus aircraft.
In 1997, China Southern Airlines successfully listed on the Hong Kong and New York Stock Exchanges. The listing raised hundreds of millions of dollars that was ploughed back into the airline, including paying for fleet expansion.
The listing also coincided with another shakeout in the Chinese airline industry. Smaller airlines were swallowed up and forcibly merged under further CAAC reforms. China Southern Airlines was one of the beneficiaries.
First off, China Southern absorbed Zhengzhou-based Zhongyuan Airlines. Shortly after, China Southern also swallowed up Shenyang-based China Northern Airlines and Urumqi-based Xinjiang Airlines.
As a result, China Southern Airlines suddenly founded itself with a substantially larger fleet and some serious growth in passenger numbers, seat capacity, and flights.
Standards keep lifting at China Southern Airlines
By the turn of the century, China Southern continued to order new planes, including investing heavily in Airbus A330 aircraft. Those A330s have since become a mainstay of the China Southern fleet.
Around the same time, China began spending up big preparing for the 2008 Beijing Olympics. China wanted to present well. They figured hordes of tourists would come in for the games, many of them flying on Chinese airlines. That meant more new planes and upgraded airline and airport infrastructure.
Coming China Southern were Airbus A380s and Boeing 787 Dreamliners. Both aircraft types began landing at China Southern well after the Olympics, but they had the effect of seriously expanding the airline’s long-haul capabilities. Having a clutch of A380s also did wonders for China Southern’s international profile.
Also boosting China Southern’s profile was a decision to join the SkyTeam alliance before the Olympics. China Southern was the first mainland Chinese airline to join a global airline alliance. One of the side effects was a concerted in-house effort at China Southern to bring the airline up to SkyTeam standards, with subsequent flow-through benefits for passengers.
Heavy-handed regulation holds China Southern back
While technically an “independent” Chinese airline listed on two stock exchanges, China Southern Airlines was and remains majority-owned by the Chinese Government and remains heavily regulated by the CAAC.
Infrastructure development within China, such as high-speed railways, saw flying within China become a more challenging game. China might have become richer, but the average Chinese traveler also had more travel options.
That saw China Southern focus on developing its international network over much of the last decade. But the heavy hand of regulation also made this a tricky business. Mainly operating to and from its Guangzhou base rendered flying to North America a tough business. Most North Americans wanted to go to Shanghai or Beijing. But Chinese law forbade China Southern from competing with Beijing-based Air China on, say, the Beijing to Los Angeles route.
China Southern Airlines matures into a globally recognized airline
The new planes ordered earlier in the century kept arriving at China Southern. But with tonnes of available capacity and the deep pockets of its ultimate owner to fall back on, China Southern effectively began capacity dumping in many international markets, offering far more seats across far more flights than many routes warranted.
This, of course, raised the ire of competitor airlines and damaged the airline’s reputation – across the industry at least. More recently, an array of factors beyond the broader international travel downturn have seen China Southern Airlines stop this practice.
Now, while still enjoying the backing of the Chinese state, there is a tighter financial focus at China Southern Airlines. The heady expansionary days might be over, but China Southern has matured into a globally recognized airline.
The travel downturn has clipped China Southern’s wings, but most expect the airline to come roaring back in a year or two. If there is one theme from China Southern’s history, it’s that the airline gets grabbing opportunities.