Deaf customers filed a lawsuit against coffee giant Starbucks this week, alleging they experienced discriminatory treatment at a NYC location on multiple occasions in the last year.
Starbucks spokesperson Jaime Riley says the company is treating the allegations very seriously, and points to a blog post detailing the global coffee chain’s policy on providing a deaf-friendly environment at its locations.
Employment lawyer Derek T. Smith says small business owners don’t always establish a clear policy for workers on customer discrimination – as they spend more time focusing on discrimination and harassment within the workplace – but they should.
“Not only is discrimination illegal in the workplace amongst employees,” says Smith, “but it’s also illegal between an employee and a customer.”
Smith says most state laws provide that any place of public accommodation that discriminates against a protected class (such as race, gender, sexual orientation, age or disability) can be found liable for discriminatory behavior.
Abrams, Fensterman employment lawyer Eric Broutman agrees business owners should not overlook the issue.
“To the extent possible, you need to make accommodations to customers to allow them the free use and enjoyment of your store,” says Broutman.
Here are five tips from Smith and Broutman on how to best educate employees about discrimination.
No. 1: Formalize training.
Smith says most training focuses on internal discrimination, so make sure any formal training includes discussions on employee-customer discrimination.
“There needs to be more of a focus, because I get inquiries every week about discrimination lawsuits,” says Smith.
Broutman adds, “It needs to be discussed with every new hire, or once a year.” He says policy manuals should also be printed out and made readily available.
No. 2: Teach them what discrimination looks like.
Any training should clear up for your staff what discrimination looks like.
For instance, sexual harassment from an employee to a customer looks very different than disability discrimination. Make sure your employees understand which classes are protected, and what different scenarios might look like.
“Any time an establishment calls someone a racial slur when they get into a fight,” says Smith, it is discrimination. “Or if they treat people differently – I’ve seen cases in stores where racial profiling has occurred. African-Americans have been followed around the store, whereas white patrons have not,” says Smith.
Smith adds that employees making comments about a customer’s physical appearance can be grounds for a sexual harassment suit. By going through various scenarios and teaching employees the different faces of discrimination, Smith says employers can go far to prevent it from happening in their establishments.
No. 3: Provide reasonable accommodations.
“If anybody has a disability, they need to be accommodated in a reasonable fashion,” says Smith. “If a person in a wheelchair has difficulty getting into your store, you need to get off your [butt] and walk over, and help the person into the store.”
No. 4: Consider installing cameras.
Smith says video footage can be crucial in catching discrimination on tape – or proving that it didn’t happen. Employers who want to make sure that all customers are being treated fairly and in a way consistent with company standards may want to consider installing cameras and periodically reviewing footage.
No. 5: Enable customers to give feedback.
If an employee mistreats a customer, the best-case scenario is that the customer reports the mistreatment to the manager, who then appropriately and quickly deals with the situation. Broutman says it’s in employers’ best interests to provide opportunities that facilitate that type of communication.
“It’s important to have managerial oversight to make sure there’s compliance [with rules regarding discrimination],” says Broutman. “Allow customers an avenue to make complaints, so if there are rogue employees, you can make sure to take necessary action.”
Broutman suggests installing a call-in number, or using social media to gain feedback.
Follow Gabrielle Karol on Twitter @GabrielleKarol
You must login to comment.