Article Text
Abstract
Background The ACR launched the RISE registry in 2014 to facilitate quality improvement on a national scale. The registry passively extracts electronic health record (EHR) data from rheumatology practices, aggregates and analyzes these data centrally, and feeds performance on quality measures back to clinicians using a web-based dashboard.
Objectives We used data from RISE to 1) examine variation in performance on quality measures across practices, and 2) evaluate trends in measure performance over time.
Methods RISE's informatics platform continuously collects data from the EHRs of participating practices, allowing centralized aggregation and analysis of quality measures. We analyzed data collected between July 1, 2014-July 1, 2016 on all patients seen by 294 clinicians across 63 practices. Measures in the areas of rheumatoid arthritis, drug safety, preventive care and gout were examined. Performance on quality measures, defined as the percentage of eligible patients receiving recommended care, was examined at the practice level. To examine trends in performance over time, we took the subset of practices that continuously participated in RISE since its inception (n=44), and developed 1) control charts and 2) logistic regression models, in which the outcome was practice-level performance each month and the predictor was time.
Results Data from 289,812 patients was examined. Mean (SD) age was 59 (16) years, 75% were female, 21% were racial/ethnic minorities, and 37% had public insurance. Most rheumatologists were in a group practice (73%); 25% were in solo practice and 2% part of a larger health system. Performance on measures varied significantly across practices (Table). The largest gaps were observed for gout and preventive care. For 4 of 5 measures for which the Medicare program has set national benchmarks, average performance of RISE practices exceeded targets. Of 11 measures, performance improved over time on 5 measures (p<0.05 in logistic models; see Figure for example control chart), was at goal on 4 measures, and saw no improvement on 2 measures (BMI screening and urate target).
Conclusions We found significant variation in performance on quality measures across RISE practices, with the largest gaps seen in gout care and preventive care. Some practices have achieved a very high level of performance. Over time, RISE practices demonstrated improvement in over half of the measures examined. As rheumatologists aim to improve quality of care, RISE will, by design, allow participants to measure, benchmark, and continuously monitor performance.