The COP26 climate conference in Glasgow is over. Despite some progress, deep concerns remain about the outcomes. The final pact at least mentions the importance of exiting coal and the door remains open to ratcheting up national targets in 2022. But we’re all still on a long, hard road through wild and unfamiliar landscapes scarred by fires, floods and storms.
Accelerating the transition to a just and resilient zero-carbon future remains humanity’s most urgent task. Scientific evidence about global warming trends already locked in is, however, crystal clear: humans and all other species are on a journey into an increasingly harsh climate future.
This realisation raises two tough questions, which led me to begin work on my new book, Hope and Courage in the Climate Crisis:
– what sources of hope and wisdom can strengthen our capacity to take courageous and effective climate action?
– how do we live meaningful lives in a world of rapidly intensifying climate and ecological risks?
There are times when I imagine all the ideas and voices I have drawn on – scientists and activists, teachers and writers, poets and artists – gathered in respectful and intense debate. The conversations spark and crackle with fierce, urgent energy.
All agree the hope we need is realistic and defiant. It is not wishful thinking, denial, or delay disguised as naïve optimism.
As my research has helped me understand, humans continue to draw on a rich diversity of ideas to sustain defiant and courageous hope in dark times.
Read more: Five things you need to know about the Glasgow Climate Pact
Science-based emergency action
I turn first to my colleagues from science and technology. Surely, they argue, our first priority remains speaking truth to power about the speed and scale of action needed to restore a safe climate?
Targets and agreements set at global conferences like COP26 are useful. But only if national and sub-national governments, cities and communities, unions and business all actually deliver on those targets and rapidly intensify their work to cut emissions, including a swift end to using coal, oil and gas.
OK, but how do we achieve the necessary political momentum? My climate activist friends seem less convinced by the promise of scientific evidence and reason.
The pandemic response has been a useful wake-up call about the possibilities as well as the limits of human ingenuity. But in the climate crisis, how do we deploy data and evidence at the speed required, while avoiding the delusional hubris that there are always technical solutions to every human problem?
Historical examples my activist colleagues turn to for inspiration are stories of solidarity and fellowship, where ethically informed collective action has achieved transformational change which once looked completely impossible.
These include the anti-slavery movement, the Suffragettes, the overthrow of Apartheid and the fall of the Berlin Wall. More recently we can look to examples like Black Lives Matter, 350.org, Pacific Climate Warriors, Beyond Zero Emissions, Market Forces and School Strike 4 Climate.
Justice, care and beauty
I turn next to my friends and colleagues from Indigenous and First Nation communities, such as the Seed Indigenous Youth Climate Network.
From them, we might learn to deepen our understanding of the histories of the lands on which we gather – and the legacies of colonialism, resistance and dispossession which have led us to these times of risk and crisis.
Climate justice – the principle that the burdens of climate change impacts and solutions should be shared fairly – is therefore one of the first propositions we should bring to the table.
In thinking about the concept of climate justice I also find it helpful to bear in mind the responses Indigenous school students gave, when Indigenous author and activist Tony Birch asked them to define climate justice:
if we fail to care for Country, it cannot care for us
This response highlights the importance of remembering that the principle of climate justice should not be restricted to humans alone.
I am joined next by teachers and scholars from a wide array of spiritual and faith-based traditions. They suggest the first key step in times of suffering and despair is thankfulness.
Buddhist poet and environmental activist Gary Snyder makes this point very well. He notes that while many severe climate impacts may already be locked in, every day he feels gratitude to this world that is.
Snyder quotes Kobayashi Issa, a poet who once wrote:
This dewdrop world
Is but a dewdrop world
And yet …
Our shared responsibility
Remembering the fragile impermanence of our dewdrop world is a constant reminder of our shared responsibility to defend the beauty of the world we’ve been given, and hand this gift on to all humans and other species who’ll come after us.
Honouring and celebrating the astonishing, complex beauty of life on Earth is also, as legendary nature writer Rachael Carson reminds us, an abiding source of strength and inspiration:.
I turn finally to the theorists and writers, farmers and engineers, poets and artists and film makers who can help us imagine and create the regenerative action we need to cross the wild landscapes of the long climate emergency.
Visionary, insightful writers like Vandana Shiva, Jeremy Lent and George Monbiot who can help us clearly see the patterns and textures of our interwoven world, and understand and confront the ignorance, violence and greed threatening to tear this delicate fabric apart.
Authors and activists such as Rebecca Solnit, Kim Stanley Robinson, and Christiana Figueres, who can assist us navigate dangerous and uncertain times, remembering that the world is always full of surprises and the future is never fully settled.
Sunlight on the water, wind in the trees
So, where might we find sources of wisdom, hope and courage in this world of rapidly intensifying climate consequences?
Honesty with ourselves and others about the scale and consequences of the crisis we now face. Scientific rigour, evidence and ingenuity. Working together, shoulder to shoulder to ignite and accelerate emergency speed action. Justice and care, respect and reciprocity. Thankfulness, kindness and compassion. Beauty, creativity and imagination.
And also these abiding gifts: the laughter of children. The comfort of old friends. Sunlight on the water, the wind in the trees, the silence of mountains, the roar of the ocean.
Read more: COP26: experts react to the UN climate summit and Glasgow Pact
John Wiseman is a Senior Research Fellow with Melbourne Climate Futures and Melbourne Sustainable Society Institute at the University of Melbourne; a Research Fellow with the Centre for Policy Development and a Board Member of The Next Economy.
He is the author of 'Hope and Courage in the Climate Crisis', Palgrave Macmillan, 2021