CLEAN EATING
What is it?
The issue with “clean eating” is that it means something different to every person – there is no consistency. For the most part, it means following a diet that includes only whole foods, or “real” foods — those that are minimally processed, refined, and handled, making them as close to their natural form as possible. These foods are labelled as “clean” foods. Any foods that are not classified as “clean” are considered “dirty” or “bad” and can include grains, sugar, alcohol, sauces, ice-cream, chocolate, cakes, burgers, pizzas, etc. Some “clean eaters” include a “cheat meal” which allows them to eat these foods once a week.
Benefits:
1. Eating whole, unprocessed “clean” foods can avoid high levels of trans fats, excessive sugar and others chemicals known to cause health issues.
2. The food/meal options are usually simple and are made up of a few ingredients (chicken breast, brown rice, broccoli), which make adjusting calorie intake/macronutrient quantities easier.
3. The repetitive nature of most clean eating diet plans can be easy for people to prepare in advance and follow.
Potential Problems:
1. Excluding certain foods/food groups for no valid reason can lead to nutrient deficiencies.
2. Eating the same food every day with minimal variety can cause food intolerances.
3. Restrictive diets may lead to antisocial behaviour and social anxiety. Excluding certain foods/food groups coupled with eating “allowed” foods on a specific schedule can make eating out at restaurants and social occasions very difficult.
4. Restriction and complete avoidance of certain foods or food groups often leads to intense cravings which results in binging. This is referred to as “cheating” and can carry with it feelings of guilt and failure. People find themselves in trapped in a binge-cheat cycle which often leads to serious eating disorders and self-loathing.
5. Most people do not track calorie intake and just “eat clean”. Yes, they often lose fat at first due to replacing higher calorie foods with low calorie options, but eventually their progress stalls. They often fail to realise that unless you create a caloric deficit, you won’t lose weight. Telling someone that they should never focus on calories and only focus on food quality often traps them in a sense of false security.
FLEXIBLE DIETING
What is it?
‘Flexible Dieting’ is simply the tracking of macronutrients (protein, carbohydrate and fat) to achieve a body composition goal. The focus is on meeting these daily targets, and not so much on what foods you eat to get there, however, it is recommended that you get at least 80% of your daily calories from healthy (micronutrient dense) foods and use the other 20% for “treats” or foods with less nutritious profiles. It allows yourself to enjoy your favourite foods in moderation without the accompanying feelings of remorse or guilt.
Benefits:
1. Flexible dieting does not label foods as “clean” or “dirty” and allows you to eat a greater variety of foods. This makes developing nutrient deficiencies and food intolerances less likely.
2. The flexibility that this approach allows increases long-term compliance and progress. Various studies have demonstrated a relationship between flexible dieting practices and the relative absence of over eating.
3. Flexible dieting reduces social restriction and anxiety by allowing you to eat out at restaurants/social occasions.
Potential Problems:
1. Although mainly a concern with extremist versions of IIFYM diets, solely counting macros and calories while ignoring other aspects of what constitutes a healthful diet (ie. the biological value of different protein sources) is a potential disadvantage.
2. Although flexible dieting allows for greater flexibility, preparing complex recipes, eating restaurant meals, and constantly changing food choices can make tracking your intake difficult.
3. You may need to limit your portions of certain (delicious) foods such as ice cream and pizza according to your daily intake, which can be difficult for some people who are stuck in a “cheat meal” mentality.
SO WHICH IS BETTER?
Firstly, changes in body composition ONLY happen as a result of your total calorie, protein, carb and fat intake. They don’t happen as a result of the specific food sources that provide those calories and macronutrients, nor do they happen as a result of the specific manner they are consumed in. By counting calories alone you can determine how much food you need to consume to either lose or gain weight, according to your goals. However, by tracking the individual macronutrients that make up these calories, you can target FAT loss or MUSCLE gain, not just WEIGHT loss or gain. This is why tracking macros is far superior to just counting calories for improving body composition.
Flexible dieting, when done properly, is a liberating approach for anyone who wants to improve their body composition without having to eat a restrictive diet made up of a limited number of “clean foods”, that are to be prepared in a certain way and that must be eaten at precise times throughout the day. If you can progress while eating a balanced diet that includes your favourite foods and is structured around your lifestyle then you are more likely to continue to be able to follow it long-term and achieve the results you desire! I like to eat nutritious foods 90% of the time and use the remainder for some dessert or meals out on the weekend. It really is about finding what works for you. At the end of the day, the most effective diet is a sustainable diet.
Want to learn more about this approach to nutrition? Sign up to my mailing list or contact me! Ready to try this approach to nutrition for yourself? Check out my custom nutrition plans and let’s get started!