The following is an archive of a post made to our
'vox-tech mailing list'
by one of its subscribers.
Hai Yi wrote:
> Thanks Jeff. However, the header file of those C routines are included
> in ffmpegmgr.h, which is in turn included by ffmpegmgr.cpp.
>
> The "undefined reference " normally indicates that the functions's
> definitions are not found, and it takes place when doing the linker.
I am aware of that. However, if you don't have your calls properly declared
then the linking may fail.
> The
> libraries, libavcodec, etc, have been specified from the g++ command
> line, and seems to work - only that I need to make the encapulated
> member function in ffmpegmgr.cpp inline to eliminate the linker error:
>
> inline void FFMpegMgr::new_video_stream(AVFormatContext *oc)
> {
> ...
> st = av_new_stream(oc, oc->nb_streams);
> ...
> }
I cannot explain that. Adding the inline keyword to new_video_stream
eliminates new_video_stream from the linking process (being placed inline,
there is no need to link it), but should have no effect on the link-ability
of av_new_stream.
Are you wrapping your C declarations as seen from C++ in extern "C" {}
blocks? This is often done by wrapping the #include statement for the C
header file in your cpp or C++ header files.
> Also, the lib that I specified is *.a, will it be different if the lib
> is *.so ?
If you declare your objects correctly, there should be no need for source
code changes between static and shared library linking.
> Thanks,
> Hai
>
>
> On Mon, Jun 7, 2010 at 1:26 AM, Jeff Newmiller <jdnewmil@dcn.davis.ca.us
> <mailto:jdnewmil@dcn.davis.ca.us>> wrote:
>
> Seems more likely that you haven't included the declarations for the
> C routines in your cpp file. Would need to see more context to diagnose.
>
> "Hai Yi" <yihai2004@gmail.com <mailto:yihai2004@gmail.com>> wrote:
>
> >Hello all:
> >
> >I created a class FFMpegMgr and a method init(); inside init() I
> just put
> >three ffmpeg api there:
> >avcodec_register_all();
> >avdevice_register_all();
> > av_register_all();
> >
> >The source file ffmpegmgr.cpp look like this:
> >
> > void FFMpegMgr::init() {
> > avcodec_register_all();
> > avdevice_register_all();
> > av_register_all();
> >
> >}
> >
> >Now I got a "undefined reference to avcodec_register_all" error.
> >
> >if I put that body in the class declaration or add a "inline"
> keyword, that
> >problem was gone and the compilation succeeded.
> >
> >question is, do those three functions, which are C functions
> defined in
> >avcodec.h, have to be used only in the inline functions in C++?
> >
> >Sorry if it appear naive - I've been out of touch with C/C++ for a
> while.
> >
> >Thanks!
> >Ha.