Contributions
While OpenStack has emerged as a leading open cloud OS, barriers to its broader adoption persist. As a top contributor to OpenStack, Intel is collaborating to enhance OpenStack’s enterprise-class capabilities, and make it easier to deploy, use and maintain. Our upstream code contributions have been instrumental in enhancing OpenStack’s reliability, availability, scalability and security, and usability. We are also working across adjacent open source communities, like OPNFV and OpenDaylight, to help bring next-gen networking capabilities to OpenStack, with focuses on more intelligent workload scheduling and definition of the Advanced Network Services Framework (ANSF). And our optimization of key runtimes—like Python, which underlies 70% of OpenStack—helps the OpenStack platform run better and faster.
Compute
- Intel’s investments in rolling upgrades, live migration, and bare metal as a service improve operations and developer productivity through increased automation and self-service.
- Through the Kolla-Kubernetes project, Intel has championed using the simplicity and power of containers to orchestrate the deployment and management of OpenStack clouds, enabling enterprises of all sizes to enjoy the same efficiencies that power large-scale public cloud operators.
- The Snap project brings advanced telemetry capabilities to OpenStack, enabling operators to get optimal use of their hardware investments.
- Intel® Rack Scale Design lowers TCO by enhancing capacity management and delivering greater flexibility, allowing you to tailor your OpenStack-based cloud to your specific needs.
- Deploying PaaS stacks such as CloudFoundry or OpenShift on top of OpenStack can improve developer productivity and time-to-market for on-prem and hybrid cloud deployments.
Networking
The ever more connected world of tomorrow, with its billions of devices, will require the flexibility and adaptability in addition to cost savings that software defined networking (SDN) and network functions virtualization (NFV) brings to the cloud. Working with the OpenStack, OpenDaylight, OPNFV and the ONAP communities, Intel is helping bring these next-gen networking capabilities to OpenStack.
- Intel is helping enable more intelligent scheduling of workloads—known as Enhanced Platform Awareness (EPA)—by providing Nova visibility into platform attributes.
- Intel has worked with customers to combine OpenStack with OpenDaylight, DPDK, and Open vSwitch to enable production-ready NFV solutions.
- With contributions from others in the community, Intel maintains networking-odl, the neutron driver for OpenDaylight.
- Intel has conducted a series of network experiments on a cluster of 66 bare metal nodes, uncovering issues, chasing down fixes, and sharing key insights with the community.*
*The initial experiment compared and contrasted the performance of two widely used Layer 2 software switching solutions, Linux Bridge (LB) and Open VSwitch (OVS), and a follow-on experiment, introduced OpenDaylight as the solution to manage the OVS switching component.
Security
- Intel has pioneered the use of hardware-assisted security features, such as Intel® Cloud Integrity Technology, Intel® Trusted Execution Technology, and Intel® Kernel Guard Technology, to address container security issues within OpenStack.
- Through Intel® Cloud Integrity Technology, Intel enables you to guarantee integrity of a virtual network function at launch.
- Intel has demonstrated how virtual network traffic within a Virtual Evolved Packet Core (vEPC) can be protected within an OpenStack installation, leveraging Intel® architecture.
- Through the Open Security Controller and its integration with OpenStack, Intel has simplified the management of multiple, heterogeneous security services—such as vIPS and vNGFW—across a diverse set of SDN controllers and security VNF vendors
Storage
- Intel has worked to integrate the Storage Performance Development Kit (SPDK) and Intel® Intelligent Storage Acceleration Library (ISA-L) with OpenStack, reducing computational overhead and improving I/O path performance while offering breakthrough performance to overcome the dilemma of the solid-state transition.
- Intel helps deliver up to 47% better storage utilization using Swift erasure coding.
Intel is re-architecting storage and memory to meet massive new challenges.
Usability
One of the biggest barriers to OpenStack’s broader adoption has been the difficulty and inconsistencies experienced in deploying, maintaining and using OpenStack—and this only becomes a graver issue as OpenStack grows. In addition to our focus on bringing enterprise-class features to OpenStack, Intel has collaborated with the community to make OpenStack easier to deploy, maintain and use through our leadership and active contributions to a variety of usability-related projects.
- Intel is helping bring greater consistency to OpenStack through our leadership and active contributions to the OpenStack Client.
- Through Intel’s contributions to OpenStack Horizon, Intel is helping provide a more simplified user interface, rolling feedback into features that matter to end users.
- Intel has conducted usability studies through the OpenStack UX project to help the community better understand and design to users’ specific needs.