Breaking Down Spain's Upcoming Election
The 20th century was not an easy one for Spain. It was devastated by a brutal civil war and then suffered for decades under the repressive dictatorship of Francisco Franco. Elected government only returned after Franco’s death in 1975 and the subsequent replacement of his regime with the current constitutional monarchy.
Since then, Spain has had tumultuous politics, which have been particularly dramatic in the past decade. Spain’s economy was hurt by the Euro crisis, and leaders in the fractured Spanish parliament have had difficulty building a lasting coalition. Through this time, cost of living has been rising in many Spanish cities, and there has been high unemployment for many years.
Conservative Prime Minister, Mariano Rajoy, of the Partido Popular, managed to remain in charge for seven years until he was toppled by a vote of no confidence in parliament. Without calling for a new election, Pedro Sanchez, of the left leaning PSOE (Partido Socialista Obrero Español, “Spanish Socialist Workers Party”) ascended to the top job despite only controlling 84 of the 350 seats in the Chamber of Deputies.
Many observers doubted this would last, and such suspicions have proved accurate: Spain is heading for its third general election in less than four years.
The parties in most European countries are typically divided between the left and the right, as well as between pro-EU and euro-sceptic parties. In Spain, the situation is complicated by the regional separatist forces in Catalonia, the Basque country, and elsewhere in Spain. Long repressed under Franco’s dictatorship, regional identities have flourished under Spanish democracy and created a complicated set of issues for both the national and regional governments.
The largest party in parliament currently is the conservative Partido Popular, or People’s Party. A member of the center-right European People’s Party group, it advocates for right-leaning policies and opposes separatism. The party’s leader, Pablo Casado, is more conservative than his predecessor (former PM Rajoy) and has taken hardline stands on immigration, which proved controversial.
The PP’s main rival is the social-democratic PSOE, the current left-of-center ruling party. Pedro Sanchez, a PSOE member, is calling the election following a major defeat of his budget proposal. Though ostensibly a financial matter, the budget debate was heavily connected to the ongoing issue of the desires of some in Catalonia to separate from Spain and become an independent state. Leaders of the Catalan independence cause wanted Prime Minister Sanchez to hold talks with an “international mediator” Sanchez’s handling of this demand satisfied neither the Catalan separatists nor the anti-separatist opposition. Their opposition sunk his budget, and brought down his government.
The timing of the budget was inauspicious; the Spanish government’s attempt to criminally prosecute leaders of the 2017 referendum on Catalan independence was ongoing during the budget debate. The referendum passed but saw less than half of eligible voters turn out. Additionally it was not run in compliance with the Spanish constitution. Following the referendum were heated and at times violent confrontations between police sent in by the national government and independence supporters. 19 days after the referendum, Prime Minister Rajoy suspended the Catalonian government and imposed direct rule. Catalonia leader Carles Puigdemont fled the country to avoid arrest.
Not only does parliament contain 17 deputies from Catalan nationalist parties, but it also includes regionalist or separatist parties from the Basque Country, Valencia, the Canary Islands, Navarre, and Asturia.
Citizens, a centrist and unionist party, has emerged in recent years as a major party in Spanish politics. It has been described as both left leaning and (more recently) right leaning. Led by Albert Rivera, who is based in Catalonia and a was a former member of both PSOE and PP, the Citizens party has been competitive in the polls, usually coming in third place.
From the left-wing, the upstart Podemos looks to upset this system. A hardline party of the left, the party and its allies promote socialism and have been linked to the Maduro regime in Venezuela, for which many Podemos members have shown ideological sympathy.
From the other end of the spectrum is an even newer force in Spanish politics: Vox. Vox is a right-wing populist party, promising a more restrictive immigration policy and positions itself well to the right of the PP. Vox was founded in 2013 and recently entered a regional parliament for the first time in Andalusia.
Amid this fractured political landscape, it remains unclear whether a stable governing coalition is viable. Sanchez’s mishandling of the budget has done no favors for his popularity. He is governing from a precarious position, his party having finished behind the PP in the last election when it was led by Sanchez himself. Casado’s shift to the right has appealed to some and turned off others, and he has also been criticized after an old essay he wrote resurfaced, rife with racist and sexist metaphors. The essay advanced a perception that Casado holds deeply racist views sympathetic to the far-right. Casado also has to fend off challenges from the PP’s right (Vox) and left (Citizens), further complicating coalition discussions.
There seem to be two likely outcomes. One is a repeat of 2015 in Spain, where an election resulted in a hung parliament, forcing then Prime Minister Rajoy to call a new vote the following year. With five parties regularly polling at over ten percent this is a very serious possibility.
Another possibility is a repeat of what happened in Sweden last year, where an inconclusive election led to a minority center left government after three rival factions from the center-left, center-right, and populist right were unable to form a coalition. Yet this situation - a relatively weak government led by the ruling center-left party - is quite similar to Sanchez’s government that just collapsed. It is possible a center-right coalition emerges in the aftermath of the vote, likely with Casado at the head.
Either way, barring an unexpected performance by one (or several) of the parties, Spain looks set for a difficult and long set of coalition talks, with a stable governing coalition looking rather unlikely..