I am old enough to remember when the “newest great thing” was an answering machine. Times, it seems, were simpler then. Or maybe it just seemed so. Anyway, there is no denying that technology has changed with alarming speed and, sluggard that the law can be, it sometimes struggles to keep up.
Back in the day, one’s John Hancock was made with a sharpened quill and iron gall ink (made by combining fermented oak marble galls with ferrous sulfate). Then, down the line, were “modern” fountain pens, ballpoints, rollerballs, IBM Selectrics and all the rest. For those of you keeping score, computers have really only been around — other than in scattered scientific settings — for about three decades, and the Internet was born only around 1991.
A raise of hands now; how many of us still rely primarily on snail mail? I thought not. Most of us, increasingly, rely on various electronic means to conduct our business. And in “most of us,” I include lawyers.
Yes, yes, I still on occasion send something through the U.S. Mail — usually birthday gifts or some such — but more and more we live in a virtual world and, to accommodate that world, the law, as a vehicle of peaceful business intercourse, gets dragged along. Thus, the Uniform Electronics Transmission Act, also known as UETA.
Uniform Rules
The Uniform Electronic Transactions Act was established under federal law in 1999.
UETA represents the first national effort at providing some uniform rules to govern transactions in electronic commerce that should serve in every state. Most, if not all states, have adopted similar rules. What UETA deals with is “electronic records and electronic signatures relating to a transaction.” It is related to the Uniform Commercial Code, but that is beyond our scope here. In the context of UETA, a “transaction” is limited to an action or set of actions occurring between two or more persons relating to the conduct of business, commercial or governmental affairs. If your eye is sharp, you’ll note that a “transaction” under UETA is not comprehensive. For example, notices, disclosures or communications by courts and governmental agencies are excluded.
UETA applies only to transactions in which the parties have agreed between them to conduct their dealings electronically. Electronic transactions are not — and may not be — forced upon anyone. What’s more, the parties can “tailor” their electronic transactions in a way that works best for them. They may waive, vary, or disclaim many, or even most of UETA’s provisions by agreement, keeping what they want in place.
What “electronic commerce” means is parties doing business with one another by electronic means. The Internet comes quickly and ubiquitously to mind.
What is essential to understand is that UETA does not create a new system of laws for the electronic marketplace. Instead, its focus is to ensure that transactions in the electronic marketplace are indistinguishable from traditional paper and ink transactions vis-a-vis their enforceability, but without wholesale changes to substantive rules of law. What UETA endeavors to accomplish is, in fact, limited; to provide a means for establishing that electronic records of transactions are the equivalent of a traditional paper record, and that those transactions — including electronic signatures — will be afforded the same legal consequence and effect, as olde tyme paper transactions. UETA stands to serve this single purpose.
Section 7
The “meat and potatoes” of UETA is found in Section 7 of UETA. Among other things, this section provides that a “record or signature may not be denied legal effect or enforceability solely because it is in electronic form.” Second, “a contract may not be denied legal effect or enforceability solely because an electronic record was used in its formation.” Third, any law that requires “a writing” may be equally satisfied by an electronic record. Fourth, any signature requirement in the law may be met if there is an electronic signature.
In essence, most of the rest of UETA lends support to the fundamental principles set out in Section 7. Other sections address legal questions about the use of electronic records and signatures. One important matter is determining when a transmission may be legally considered to have been sent (and/or delivered) if in electronic form. Another establishes when electronic delivery occurs and “replaces” the traditional and statutory rules that govern mail delivery in the context of electronic transactions.
Another important rule is that dealing with “attribution.” As electronic transactions are essentially “anonymous,” UETA prescribes when a “signature” is attributable to a particular, identifiable being; in effect, when it can be considered to be the act of a particular individual. What UETA provides is that attribution may be shown in any manner. Section 9 of UETA provides guidance in how it may be shown that a particular transmission is in fact the act of a particular sender.
While UETA facilitates the use of digital signatures and other security procedures, nothing in the act actually requires the use of a digital signature or for that matter any particular security protocol or procedure. The act is, instead, “technology neutral.” Persons can use whatever digital signature technology or security procedures they please, but whatever means and methods they employ can be offered to prove the transaction was consummated (or not) if there is, one day, a dispute.
UETA may be considered procedural rather than substantive; it does not require anybody to use electronic transactions or to rely upon electronic records and signatures. It does not prohibit paper records and/or manual signatures. Basic rules of law and contract continue to apply as they have since time immemorial.
UETA is one of many legal devices that intend to pull law and commerce into the 21st century. To be sure, it will evolve as electronic commerce itself evolves. One thing is certain though; there will be more and more changes to come as the world moves ever faster into an increasingly virtual existence.