Death of the Salesmen: The Geeks Did It
- 04/24/2012
- Business Intelligence
- 1
The history of business is marked by innovations meant to reduce the dependency on salespeople.
In the medieval era, when traveling peddlers risked robbery and murder on lonely roads, enterprising souls hosted fairs as a way of drawing customers to a central (and presumably safer) location. But those oh-so-convenient fairs also rendered it more difficult for your average peddler to make a living, if he insisted on sticking with his travel circuit.
Centuries later, the rise of mail-order catalogs—and then e-commerce—ended the careers of many a traveling salesperson. (Willy Loman never stood a chance, in any case.)
And now, in the first years of the 21st century, a combination of Big Data, predictive analytics and social networking might make salespeople (at least as we know them) obsolete once and for all.
Traditionally, salespeople identify potential prospects and induce them into consuming a particular item or service. As social networking evolves, it’s become a lot easier to apply analytics software to the treasure trove of Big Data repositories in a way that not only improves the identification of potential customers, but also what the latter will actually buy.
As a result of that, marketing organizations (which have an affinity for analytics software) are not only taking over the task of identifying potential prospects; they’ve become more adept at identifying which customers are likely to buy or upgrade a product or service at any given point in time. Marketing organizations then pass on the data to customer service representatives, rather than salespeople.
According to Esteban Kolsky, principal and founder of the market research firm ThinkJar, the end result of that shift is marketing and customer service quickly taking over more of the responsibilities traditionally handled by salespeople, sharply reducing the latter’s numbers.
Vinay Iyer, vice president of global marketing at SAP, takes that proposition one step further by suggesting that, at some point soon, the need for salespeople could disappear entirely: “As predictive analytics gets better, the whole lead generation process will be transformed.”
To help facilitate the transformation, SAP will soon release SAP Account Intelligence, an application that analyzes internal and external data about customers in real time using the SAP High Performance Analytics Appliance (HANA) in-memory computing platform as a cloud computing service.
SAP Account Intelligence allows companies to aggregate all customer information inside one data source, which the user can leverage (via automated recommendation engines) to determine what goods and services that customer will need next. Applications such as SAP Account Intelligence herald a new era of customer experience management that will redefine business roles across the entire organization.
Jeremiah Owyang, an analyst at the Altimeter Group, thinks the transformation will take some time to play out, but that eventually the shifting of responsibilities will concentrate more power in the hands of companies’ chief marketing officer. It could very well spark the fundamental restructuring of business operations as marketing, sales and customer service functions continue to converge.
“The rules are changing as companies embrace more strategic approaches to managing customers,” he said.
Furthermore, companies are becoming more adept at leveraging social media and other sources of data to create “social graphs” that not only identify all the relevant decision-makers within an organization, but also their interests and locations—and ultimately the best “moment of opportunity” to reach out to them. That information, Owyang added, is utilized to create relationships with potential customers that have much more context than most salespeople, trying to drive a specific transaction, could ever possess.
Larry Augustin, CEO of SugarCRM, a provider of open source customer relationship management (CRM) software, believes it’s already pretty clear that CRM software is necessarily evolving into applications that aggregate all the information related to managing the customer experience. “CRM will evolve into an application category that will go way beyond being a tool for managing the sales staff,” he said.
Of course, the transformational pace depends on the rate at which marketers in various vertical industries become more IT savvy, as well as how closely they can work with their IT colleagues. That aside, new IT tools will surely alter the way sales are both conducted and managed. The only question is whether the Willy Lomans of the world will resist the shift, and for how long.
Image: @erics/shutterstock
August 28, 2013 at 8:50 pm, SAP Outlines Its Unified E-Commerce Strategy | iqblog.cz said:
[…] analytics to better anticipate what customers are likely to purchase next. The end result will be a fundamental transformation of the role of salespeople within any organization as customer service representatives take on a much bigger role in terms of upselling existing […]