Alcohol and Islam: An Overview
Academic journal article
By Michalak, Laurence; Trocki, Karen
Contemporary Drug Problems , Vol. 33, No. 4 , Winter 2006
Trocki, Karen
Article excerpt
Alcohol and Islam is a relatively understudied topic, although alcohol abuse is a significant social problem both in Muslim majority countries and among Muslim minorities. Questions of religious identity as they relate to food and drink prescriptions and proscriptions also make alcohol and Islam a worthwhile topic. This article offers a general overview of alcohol and Islam. It briefly introduces alcohol and Islam in history; examines the main Islamic religious sources (the Quran, the sayings and practices of the Prophet Muhammad, and Islamic law); analyzes World Health Organization statistics on contemporary patterns of abstention and alcohol consumption in Muslim majority countries; reviews the social science literature on alcohol studies in Muslim settings; presents Saudi Arabia and Turkey as opposite extremes of prohibition and permissiveness in Muslim majority countries; offers France as a case study of the effects of migration on abstention and drinking patterns of Muslims in minority settings (about a quarter of all Muslims live as religious minorities); and looks at the rationales that some Muslims give for drinking. In conclusion, the article places the problem of alcohol prohibition in a larger context of how to approach food and drink prescriptions and proscriptions; it also cautions against overestimating the influence of Islam, and suggests an agenda for future studies of alcohol-related beliefs and behaviors among Muslims.
Which is the worst deed: to kill a man, to rape a woman, or to get drunk? Drunkenness is the worst because the drunkard will commit both rape and murder.
- Islamic saying (Aziz Omrane, personal communication, Tunis 1992)
Given the vast literature of books and journals specialized in the study of alcohol, the existing scholarship on Islam and alcohol seems small. It consists of a modest number of publications about alcohol-related attitudes and behaviors of Muslims and about alcohol in Islamic doctrine - the former from a social science perspective and the latter from a religious doctrinal perspective. Since Muslims constitute about a fifth of the world's population - about 1.3 billion people - this would appear to be an underdeveloped area within alcohol studies. The paucity of research in this subfield is in a way not surprising because alcohol is forbidden in Islam and Muslim countries tend to have low rates of alcohol consumption. Yet the topic is important, in part because alcohol abuse among Muslims is a significant social problem, both in Muslim countries and among Muslims in countries where they are a minority, but also because of other considerations besides social pathology that make alcohol and Islam a timely topic.
This article offers an overview of the topic of alcohol and Islam, addressing such questions as: What are the patterns of alcohol consumption in Muslim countries? What does the social science literature teach us about alcohol and Muslims? What normative behaviors with regard to alcohol are prescribed by Islamic textual sources and how did these norms evolve? What is the range of practice of Muslims with regard to alcohol consumption in different parts of the world today, in both Islamic majority countries and in countries in which Muslims are a minority? What happens when Muslims emigrate from a country where alcohol is discouraged to a country where alcohol is permitted and even positively valued? Since Islam forbids alcohol, how do Muslims who drink explain their behavior? We conclude with an agenda for suggested future studies of alcohol-related beliefs and behaviors of Muslims.
Alcohol and Islam in history
Paradoxically, it was Muslim chemists who were responsible for developing distillation to a high level of sophistication and transmitting it to Europe via Spain. Although distillation is a process which arose independently in different places in the world, Muslims greatly improved distillation technology. In the eighth century Muslims developed that distinctively shaped apparatus which is a staple of every chemistry laboratory - the alembic - for the efficient collection of distillate through a descending condensation tube. …