The Simple Mind-Altering Habits That Will Beat Procrastination—for Good
Procrastination can be particularly pesky when we are just trying to get something done. Why is it so hard to focus and just, well, meet our own deadlines? Of course, this idea of putting things off isn’t a new one—rather, people have been grappling with it for centuries. In fact, the practice itself dates back as early as 800 B.C., when the Greek poet Hesiod warned readers not to “put your work off till tomorrow and the day after.”
But the practice itself is much more than just putting things off—it’s actually an emotional response. “As I tell people, to tell the chronic procrastinator to just do it would be like saying to a clinically depressed person, cheer up,” says Joseph Ferrari, a professor of psychology at DePaul University and an expert on procrastination. The good news is, whether you are a chronic procrastinator or occasional procrastinator, there are some simple tricks that will help you get back on track. Scroll through to read the top six hacks for how to beat procrastination.
Make a master to-do list
It can be overwhelming when all your tasks are jumbled around in your head. Start by making a physical master to-do list, and then break all of the tasks down into smaller lists that you can reasonably tackle. (Make this job more fun by investing in a pretty notepad.) Reassess each day and be sure to add new tasks that pop up. Once everything is laid out on paper and you have a game plan (and solid deadline), it’s not as easy to procrastinate.
Start with the hardest thing
It may sound counterintuitive, but when you tackle the most challenging thing first, your list of things to do will instantly seem smaller. “Checking it off will make you feel super productive,” says Eva Wisnik, a time-management trainer in New York City who works with business professionals. What’s more, you’ll be able to focus your attention on other things that you didn’t have time (or energy) for before.
Hold yourself accountable
This technique is “positive pressure,” says life coach Cheryl Richardson, author of Take Time for Your Life. Richardson says when you are open and share your tasks with a friend, you’ll be likelier to follow through long-term. There is power in numbers, and you (and your friend) will hold you accountable for finishing what you started… which is exactly what you want and how to beat procrastination.
Find your most productive environment
It may be Starbucks, the library, or a quiet nook in your home—just be sure to locate the spot that works best for you, suggests Business Insider. Some people thrive with background noise while others need absolute silence to get things done. Once you find this place, try not to do anything but be productive there—your body will automatically catch on that this is the spot you go to accomplish tasks.
Break work into smaller increments
“If the boss hands you an assignment, she doesn’t say, ‘Work on this each day,’” says Gene Perret, author of Write Your Book Now! “No. She says, ‘Have this on my desk by next Friday.’” As adults, we have to learn how to appropriately manage our own time and projects. Do you remember how in grade school your teacher would schedule “mini” deadlines for projects? Your first page would be due one week, the second a week later, and so forth? You can apply this same principle to jobs you have to do now. For example, if you’re going to prepare your taxes, schedule one block of time for tracking down your receipts, another for requesting any forms you may need, and so on. Then, each time you hit a deadline, it will be a mini victory and you’ll be one step closer to the larger goal at hand.
Reward yourself
A little positive reinforcement tends to go a long way. Perret suggests treating yourself to a nice meal or going to a movie when you hit an important goal or deadline. Your reward doesn’t have to be outrageous, but the thought of it should encourage you to pick up the pace while you’re trying to hit your target!
Tell us what you think about these hacks for how to beat procrastination in the comments.