To a decaying primary school in Oban, to the prestigious Lighthouse in Glasgow, to the Arctic Circle Conference in Reykjavik and then the famous West Ward Works in Dundee – the Prospect North exhibition has well and truly made waves on either side of the Norwegian sea.
Scotland’s entry to the 15th International Architecture Exhibition of la Biennale di Venezia, was designed and curated by Lateral North, and explored the relationship between: people, places, cultures, and industries throughout the peripheral northern isles such as Shetland, all the way down to the central belt in Glasgow. The exhibit honed in on communities which are using grassroots actions, and local endeavours, to create unique architectural builds to stimulate their own economies. Yet it had its Scottish premier in a decomposing, former primary school, in the small seaside town of Oban. Not exactly the first location you think of for an exclusive exhibition premier.
Rockfield Primary School was opened in 1894 and closed nine years ago, and since its closure, the grade-B listed historical building had lain empty. Nobody would invest in it. In 2012 it was to be bulldozed down to create housing, but this led to Oban Communities Trust intervening to save the former school, and convert it into a cultural hub for the townspeople. The bid to purchase the building was approved by Argyll and Bute Council in 2015, and set the starting point to turn this damp, trodden and tired old build, into a vigorous, charming space in which to promote arts, culture and heritage. The intention of beneficial social and economic gain, from The Rockfield Centre project, was the driving factor behind the building being selected to hold the Prospect North exhibit.
Cabinet Secretary for Culture, Tourism and External Affairs, Fiona Hyslop said: “The development process at The Rockfield Centre is admirable, and there is great synchronicity between the aims for the Centre, and aims of the projects shown within Prospect North.
“The exhibition centres on exemplary community-led projects and so one could not wish for a more appropriate setting to have launched its tour.”
As part of the Scottish government’s year of Innovation, Architecture and Design, Architecture and Design Scotland (ADS) – who selected Lateral North for the Venice Biennale – became largely involved with the organisation of different events throughout the country, to coincide with 2016’s themed year. Upon Oban Communities Trust’s proposal for the Oban Festival of Architecture, the two organisations worked in alliance, to provide an opportunity to draw together an engaging series of local attractions, events and smaller exhibitions, in conjunction with the premier of Prospect North at the Rockfield Centre.
Chair of ADS, Karen Anderson, said: “Once we saw the space and the opportunity, we felt that Oban was the right place to bring the exhibition for its Scottish premier, after its time in Venice.
“The enthusiasm of the community, and the Rockfield Centre itself, meant that we were delighted to bring Prospect North to Oban.”
The exhibition showcased Scotland and its strategic positioning among its Nordic and arctic neighbours. Using augmented reality and VR headsets, the content was brought to life and demonstrated how architects and designers, have responded to challenges and opportunities across the country in recent years. The VR capabilities have the potential to enhance communities’ understanding of the vision for architectural projects, and allow greater access to participating in them, particularly those living in rural areas of the country.
On the use of cutting-edge technology and software used within the exhibition, Anderson stated: “The approach by Lateral North and the fantastic technology developed by Soluis is a new way for audiences to engage with the stories of the places around us.
“Their energy and vision made a huge contribution to the year of innovation, architecture and design, and I hope that their success provides inspiration to other people starting out in their chosen careers.”
The exhibition was in-fact the evolution of what originally begun as part of a Strathclyde University student masters project in 2013, titled, From Fringe to Frontier. The then students – and now directors and co-founders of Lateral North – Tom Smith and Graham Hogg, began to look at Scotland’s relation to the north. This process snowballed into projects such as Prospect North, which has allowed the Glasgow-based research and design collective to work collaboratively alongside: academics, entrepreneurs, economists, politicians and creatives around the world.
Smith said: “It was a great honour and step up, for us to deliver a project,that represented our home country on behalf of the Venice partnership.
“As a young architecture firm, we were inexperienced in delivering a project of this notability, but we felt as though this allowed us to approach the project in a slightly different manner – our youthfulness and ambitiousness was something that we wanted to carry throughout the exhibition.”
While Lateral North’s commissioned exhibition came to a finish at the end of November in Dundee, communities across Scotland can still experience the entire thing. The miniature version hosts all the same components, allowing people in urban, suburban, rural, remote, coastal and island areas, to see what the Venice Biennale entry had to offer, from the inside of a van. Or as Smith puts it, “a travelling workshop.”
He continued: “The exhibition was about promoting Scotland on both micro and macro scales, where community and designer collaboration, was at the heart of what was delivered.
“The intent was to show this to as broad an audience as possible – both international and domestic – to convey what is happening in our country right now.
“And I believe that has been accomplished, as our evolved student project has now travelled across the seas, it has shown people from around the globe what architecture and design in Scotland has to offer.”