Energy harvesting: Lighting the office - by walking
Strange as it may seem, human footsteps could play a significant role in solving the world's energy problems.
That, at least, is the view of Laurence Kemball-Cook, an enthusiastic, 27-year-old, London-based entrepreneur.
His company, Pavegen Systems, produces floor tiles that generate electricity through being walked on.
The combination of the weight of the person and a 5mm movement in the tile is used to generate an electrical current.
So far, this has mainly been to power lighting, but there are other applications.One step ahead
It is intended for places with lots of people passing through, such as railway stations, shopping centres, offices and public buildings.
It has been tested in some high profile venues, including one of the main transport hubs for the Olympic Games in London last year.
More than one million people tramped over Pavegen tiles as they passed through West Ham underground station en route for the Olympic Park, generating the power required to keep the station's lights on.
Pavegen also created an energy self-sufficient dance floor.
“Start Quote
End Quote Lawrence Kemball-Cook PavegenEnd Quote Lawrence Kemball-Cook Pavegen
This isn't just about niche one-off applications”
Dancers generated the electricity needed to run the event jumping around on the tiles.
However Lawrence Kemball-Cook has vastly more ambitious plans.
"This isn't just about niche one-off applications", he explains.
"It is about permanent installations where you have got high footfall that can power commercially viable applications."
He says Pavegen is working with big infrastructure companies like Mott MacDonald to develop large scale uses for the technology.
"We're looking to scale up and industrialise our product," he says.
The company claims its electricity-producing tiles cost about the same to install as other types of flooring in new buildings, although the costs for retrofitting existing floors are higher.
There seems to be no limit to their aspirations.
"We see our technology as a key component in the smart cities of the future," says Mr Kemball-Cook.
"Energy efficiency isn't just about how big your wind farm is, it is also about reducing the consumption of current electronics."
He believes Pavegen tiles can help because they lessen the demand for power from the grid, which frequently comes from power stations running on highly polluting, global-warming-inducing fossil fuels.
Mr Kemball-Cook comes across as the archetypal, brash, young entrepreneur, brimming with ideas and self-confidence.
"We believe we might be the Facebook of the kinetic energy harvesting space, which is going to be a huge sector in future," he says.
He came up with the idea while studying industrial design at Loughborough University, and then started the company from a rented flat in south London, with just £50 (US $75) in his pocket.
Four years later, Pavegen has 30 staff and says it is involved in projects on every continent.
The main office is near Kings Cross railway station in central London, a formerly seedy area that has become popular as a base for technology start-ups.
The company raised the cash needed to develop its concept through two funding rounds, mostly from angel investors, but now claims to be financially self-sufficient.Step into the future
Pavegen is one of many companies that see a bright future in "energy harvesting".
The term means drawing power from what is happening naturally in the world around us.
Dr Paul Weaver of the UK's National Physical Laboratory says energy harvesting technologies fall into two categories:
• Piezoelectric devices which contain materials - usually ceramics or polymers - that self-generate power through being squeezed or stretched. They are activated through vibration and other forms of natural movement.
• Thermoelectric devices based on materials that create a charge through changes in temperature.
Piezoelectric technologies, in his view, will never produce power on the scale required to make a dent in global energy demand.
What they could do, though, is replace batteries for small scale applications.
Dr Weaver says they are particularly useful in places where it is dangerous or inconvenient for humans to go.
Batteries need to be periodically recharged or replaced.
By contrast, piezoelectric devices don't require maintenance, or other human intervention, because they typically get their power from vibrations in the natural environment.
They are also less polluting as, unlike batteries, they don't contain toxic chemicals.
The technology could have many applications for things like sensors and wearable electronics, and is already established in niche areas, such as controls systems for industrial machinery.
Dr Weaver works on a massive Metrology for Energy Harvesting Project, involving 7 European research establishments, which is developing common standards and measures for judging the efficiency of different electricity generating materials and technologies.
He believes the main demand for thermoelectric devices will be in transport.
Major car makers, including BMW, Volkswagen, Ford and General Motors, are eyeing this technology to make use of the waste heat from vehicle exhaust pipes.
One day it may be possible to run a car's entire electrical system by converting heat from the exhaust pipe into electricity.
Experts say this has the potential to make vehicles 5%-10% more efficient, which - given the huge numbers of cars on the roads - would lead to substantial energy savings.
Thermoelectric principles have already had an impact in space.
Nasa's Curiosity Rover is trundling around Mars using a thermoelectric propulsion system.
However, it is not a system likely to find much favour here on Earth as the heat source is a highly radioactive material.
When people talk about renewable energy they generally mean wind farms and solar panels.
But that isn't the complete picture.
We need to recognise that jumping, walking, vibration, waste heat and all manner of other everyday things may also have a part to play in "greening" the world's energy supply.