Tu.
"Patients have a less invasive treatment option for receding gums and we now have evidence to support the stability of this relatively painless procedure. Instead of leaving the dental office with stitches in the roof of their mouth, a patient leaves with a small bandage on the arm that can be removed in an hour," said Terrence Griffin, DMD, associate professor, chair of the department of periodontology, and director of postdoctoral periodontology at Tufts University School of Dental Medicine in Boston.
"One of our previous research studies showed that all of the post-operative bleeding and most of the post-operative pain were related to the gum tissue removed from the roof of the mouth for use as a graft," he continued.
Traditional gum grafting surgery requires surgically excising tissue from the roof of the mouth (the palate) to replace the gum tissue lost around the teeth. Unfortunately, removing tissue from the roof of the mouth extends recovery time and is a major source of patients' discomfort or pain. According to the American Academy of Periodontology, periodontal disease is the primary cause of tooth loss in adults aged 35 and older. Periodontal disease includes gum recession, also called gingival recession, which can result in tooth root decay and tooth loss.
The new tissue regeneration application from Tufts uses platelet concentrate gel applied to a collagen membrane as the graft instead of using tissue from the roof of the mouth. The graft is soaked in the patient's platelets, using blood drawn in the same visit. Placed over the receding tooth root, the graft is then surgically secured.
In order to examine three-year efficacy of the treatment, measurements were taken from six patients in the gum recession area at baseline, 6, and 36 months after surgery. At six months, 24 out of 37 teeth from the six patients had complete root coverage (65 percent). At 36 months, 21 out of 37 teeth from the six patients had complete root coverage (57 percent). The authors said that the recession over three years was minimal and that the results are comparable to traditional gum grafting surgery.
"Our previous research determined that pain and discomfort were barriers to receiving traditional gum grafting surgery.* We have also shown previously that this treatment for gum recession results in proper coverage of the tooth root, better esthetics than those found with traditional gum grafting surgery, and enhanced patient satisfaction with the results,"** said co-author Wai Cheung, DMD, MS, assistant professor in the department of periodontology at Tufts University School of Dental Medicine.
Over the last decade, Griffin and his colleagues, including Cheung, have studied alternatives to traditional gum grafting surgery and have more than 20 publications on the topic.
"Gum disease affects most American adults and research is linking periodontal disease to other health problems, including heart disease. Encouraging patients to undergo surgery to fix receding gums can be difficult because the mere thought of this dental surgery is often associated with considerable pain. This treatment, while only marginally more expensive for the patient, is more time-consuming and technically more difficult for us but the end result — improved esthetics, reduced pain, and, most importantly, improved oral health for the patient — make it a valuable and important alternative," said Griffin.
More information:
Notes:
* Griffin TJ, Cheung WS, Zavras AI, and Damoulis PD. Journal of Periodontology. 2006. (December); 77(12): 2070-2079. "Postoperative complications following gingival augmentation procedures."
**Cheung WS, Griffin TJ. Journal of Periodontology. 2004. (December); 75 (12): 1678-1687. "A comparative study of root coverage with connective tissue and platelet concentrate grafts: 8-month results."
Source: Tufts University
Explore further:
Minipool technology to prepare immunoglobulins to fight viral infections in developing countries
E_L_Earnhardt