As the Z900 flicked sweetly through another set of bends in the hills near Almería, feeling impressively light and well-balanced on these twisty Spanish roads, a flashback from my journey to get here confirmed why Kawasaki’s new naked four was behaving so much better than its predecessor the Z800 could have done.
I’d ridden to the airport on my own bike, laden down with a large, unwieldy kit-bag which, the airline scales had revealed, was right on the 20kg limit. Given that the Z900 is not only 12bhp more powerful than the Z800 but also lighter by more than the weight of that hefty bag, it’s no surprise that the new naked four felt lively and manoeuvrable.
The Z900 is an important bike for Kawasaki because its predecessor was among the firm’s most popular models, despite being distinctly on the sturdy side itself, even topping the sales charts in some foreign markets. But there was plenty of room for improvement because, as the new bike’s project leader, Seiji Hagio, admits, owners’ feedback on the Z800 tended to describe it as “fun and exciting… but heavy”.
That partly explains this substantial redesign, which incorporates an all-new chassis as well as a larger capacity engine designed to boost performance while meeting Euro 4 emissions regs. Capacity goes up from 806cc to 948cc, and the chassis is transformed by the adoption of a tubular steel trellis frame that is far lighter than the Z800’s simpler steel structure.
That capacity was reached not by enlarging the Z800 engine but by reducing the Z1000’s 1043cc unit’s bore size from 77 to 73.4mm, and keeping the 56mm stroke unchanged. Throttle diameters are also 2mm down on the bigger engine’s, there’s a new slip and assist clutch, plus a redesigned four-into-one exhaust. Maximum power is 123bhp at 8000rpm, roughly midway between the Z800’s 111bhp and the Z1000’s 140bhp.
Part of the reason that the Z800 was heavy was because it was a more powerful version of the long-running Z750, whose old-style steel frame had been reinforced to cope with its increased output. By contrast the Z900’s trellis of high-tensile steel was purpose designed for the task, using techniques perfected by Kawasaki when developing the fearsome Ninja H2. It weighs just 13.5kg, with the aluminium swingarm adding a further 3.9kg.
That all helps give a kerb weight of 210kg, an impressive 21kg reduction over the Z800. The Kawasaki felt respectably light and manoeuvrable as I set off, its simple feel exaggerated by the view: raised handlebar, petrol tank, no visible flyscreen or headlight up front. And very basic switchgear, because the Z900 doesn’t offer electronic options such as multiple modes or traction control.
There was no need for alternative modes because the one provided worked perfectly well, the Zed’s sweet throttle response combining with its broad, glitch-free torque delivery and light-action, slip-assist clutch to make the bike very easy to ride. The first five gears are relatively closely spaced, with a larger gap after that to give a slight overdrive feel for top-gear cruising.
Not that a bigger gap between ratios would have been a problem. The Kawasaki pulled sufficiently hard through the midrange that I didn’t have to worry about which gear it was in, as we headed south towards the Mediterranean from the launch base at La Envía, then along the fairly busy coast road where its ability to overtake on a brief burst of throttle was welcome.
A short stretch of A7 motorway was enough to confirm that it has plenty at the top-end, too, as the bike stormed forward enthusiastically, staying smooth as the analogue tacho jabbed towards the 11,000rpm redline in the lower gears, accompanied by a flash of the adjustable shift light. Inevitably there was plenty of wind-blast at higher speeds, as there’s virtually no protection. I didn’t find noisy turbulence a problem but was a bit disappointed by the Zed’s muted intake sound, which didn’t match the Z1000’s howl although Kawasaki say they tuned the airbox specially.
Chassis performance, on the other hand, was well up to expectations. The bike was reassuringly solid on the highway, but once we’d headed north onto twistier roads its respectably light weight, fairly sporty geometry and capable, if fairly basic suspension combined to make it both fun and easy to ride. It steered with a very neutral feel, with minimal effort required even when rapid direction changes were required.
There’s 120mm of travel from the 41mm upside down forks, and 140mm from the near horizontally mounted, rising-rate shock. That seemed about right, and was enough to allow decent ride quality. And both ends were sufficiently firm and well damped to keep the Kawasaki feeling controllable even when the pace got pretty hectic, and it was slowing hard into the hairpins thanks to its respectably powerful front-brake blend of four-pot calipers and 300mm wavy discs.
The Dunlop D21 rubber didn’t let it down either, and there was ample ground clearance on mostly smooth but occasionally dusty Spanish roads. One slightly surprising omission was a traction control system, as featured on rivals including Suzuki’s GSX-S750, Yamaha’s MT-09 and Triumph’s revamped Street Triple.
Kawasaki say they concentrated on keeping the bike simple and controllable, though cost and market positioning presumably influenced the decision. So despite its modern, Sugomi-influenced look the Z900 lives up to its name by having a slightly basic, old-school character, which some potential buyers will doubtless like just fine.
The 900’s blend of strong, flexible engine performance, capable chassis and rider-friendly nature comes in green, black or grey paintwork, at what looks like a pretty competitive price of £8249. That’s a useful £2000 less than the more powerful, heavier and slightly more high-tech Z1000.
In Kawasaki tradition there’s also an accessorised version, the Z900 Performance Edition, which features a flyscreen, tank pad, pillion seat cover and Akrapovic silencer, and costs £8999. Either way, this Z900 isn’t landmark model that will be recalled in decades to come, like its famous forebear, but it’s a timely and well-executed successor to the Z800, and good enough to keep Kawasaki’s four-cylinder family popular despite some increasingly tough opposition.
TECHNICAL SPECIFICATIONS