Lately, we’ve been hearing a lot of discussions around the use of DevOps and DevSecOps. Although these are considered very good practices, I believe many organizations aren’t doing it properly or even aren’t prepared for them just yet. These practices demand many cultural changes in organizations, which most of them aren’t prepared for or are welcome to changes. Just using tools and automation is not enough to achieve the cultural change needed. Many researchers and authors believe that DevOps itself already includes security in its core and although they may be right since software security is closely related to software quality. Unfortunately, that’s not the case in most of the companies adopting DevOps yet.
Many organizations are applying DevOps without thinking about Security. That’s why, I believe, a new term was created, first called Rugged DevOps, or SecDevOps, or DevOpsSec and lately DevSecOps (other terms you may found out here are Agile Security, Agile SDLC or DevOps Security). The goal of DevSecOps, in my opinion, is to raise awareness of the increasing need for security in this shifting culture using the agile and automation mindset. DevSecOps is an evolution to DevOps to make sure that security teams stop being the bottleneck for digital transformation.
DevSecOps is changing the Application Security industry by integrating security verifications and checks within the development process and reducing the vulnerabilities found before launching into production. According to Gartner, here’s their definition of DevSecOps:
“DevSecOps can be depicted graphically as the rapid and agile iteration from development (the left side of Figure 1) into operations (the right side of Figure 1), with continuous monitoring and analytics at the core.
Currently, security testing is generally performed at the end of the application development process, which increases the risks of deployment delays and project costs. Especially if vulnerabilities that require recoding or redesign are found. Companies can overcome this problem by using the “Shift Security Left” (SSL) approach, which according to Accenture and AWS basically says that it “introduces security at the inception of the development lifecycle and automates testing within the DevOps workflow.” Please don’t confuse that approach with the SSL/TLS encryption protocols. Let’s discuss some of these practices and how you can apply them in your software development scenario.
Outdated and vulnerable libraries (SCA)
One of the biggest problems related to security that organizations face is knowing what’s exactly inside their applications and how to properly and securely patch them. We can all remember the damage that was caused by Wannacry in 2017, which exploited a vulnerability that was fixed three months before the attack was launched. In the same year, Equifax was also breached, in another big attack that was news all over the world, because of an outdated and vulnerable version of the Apache Struts library, which allowed the execution of remote commands on their systems4.
Nowadays it is very rare, if not never,.” – OWASP Top 10 2017
A great example of this issue is WordPress, a famous CMS system that has a strong and well-tested core, at least nowadays, but its themes and plugins are very problematic and unreliable since they are developed by third-party developers that don’t always follow the same security procedures and verifications in their development process as the core WordPress team.
There are many tools out there that check for outdated software on servers and even update those for you. But that’s not an easy task especially because of the incompatibility issues with legacy applications and the lack of proper regression testing to make sure everything is working properly once the updates are made. That becomes even harder when the outdated library is embedded in a custom or in-house application and the tools mentioned earlier won’t work on them. So, what can be done is to verify these issues before the application is even built, generally during the development phase or during pre-build tasks.
There are many tools available that will perform those tasks for you in many different languages and frameworks, some of them can even be integrated into your developers’ IDE and they check and fix these issues before submitting any new code. OWASP has a great free tool available for Java and .NET libraries called OWASP Dependency Check, which also has plugins for CI tools like Jenkins. Other commercial tools that can help you in this process are Snyk, WhiteSource, Synopsis BlackDuck, Veracode SCA, Conviso AppSec Flow and Sonatype Nexus IQ Server.
Automated security scans (DAST)
As we mentioned before security scans are mostly performed at the end of the application development process, usually after the application has been done and it is properly working at least on a Dev or QA environment. So any issues found would either need a system update of some kind or recode to fix the application., containers, orchestrators and serverless it has become very quick and easy to create and destroy environments for testing or proof-of-concept (PoC). For a full list, please check the OWASP Vulnerability Scanning Tools list.
Security code reviews (SAST) number of vulnerabilities in your software after deployment that would need any code change. It will also give your developers fast feedback about the mistakes they are making fast feedback about the security of their applications to take action. Remember what matters to the business and try to balance security with new features.