Take another look at this picture of the Rokeby Venus from last week’s post on mirrors in art:
Now, imagine you’re actually in the room with Venus, as depicted in this painting. You suspend your astonishment long enough to conduct a quick test of the principle of how a flat mirror works. Consider what would happen to Venus’ face in the mirror as you approach it. As you walk towards the mirror, would the proportion of the reflection taken up by Venus’s face increase or decrease? In the painting, the face takes about 2/3 the width of the mirror. Would that proportion get bigger or smaller as you get closer? Let’s make this a poll:
Now imagine the cupid moves the mirror so you see your own reflection in it. As you walk away from the mirror, what happens to your reflection?
We have an unusually savvy and educated readership here, but for most people, those questions are quite difficult, despite the fact that we see mirrors every day.
In fact, as Marco Bertamini pointed out in a comment on last week’s post, his team of researchers got it wrong in their article about the Venus effect. Even art critics discussing the role of mirrors can make incorrect generalizations about how mirrors work, a point Marco Bertamini’s team of researchers made in their article about the Venus effect.
As you get farther away from the Venus, the projection of her face in the mirror approaches the actual size of her face. As you get closer, the proportion of the mirror occupied by her face decreases. So the face in the mirror is only too big if you assume the viewer is located relatively close to the mirror. If the experts can’t get this detail right, what chance do non-experts have?
Bertamini has continued to investigate our perception of mirror images. In 2007, a team led by Rebecca Lawson and including Bertamini and Dan Liu, came to a startling conclusion: “There is no percept for the 2-D projection on the surface of a mirror or window.” In other words, we don’t ever directly perceive the image on the mirror — we see only the object that’s reflected.
We are quite good at judging the size of objects if we know their distance from us. We almost automatically take distance into account when judging an object’s size, and despite the fact that objects literally appear smaller when they are farther away (they take up a smaller portion of our retina), we believe that they are the same size. In other words, we don’t think cars get smaller as they drive away. But when looking at a mirror, most people are suddenly much less accurate at judging the size of a reflection.
Lawson’s team had students stand two meters away from a large mirror. A researcher held a bamboo stick above the student’s head, behind a piece of wood so that the student couldn’t see the stick directly, only via its reflection. Students were asked to judge the length of the stick itself by extending a tape measure held at their side to match the length of the stick. Then they used the same method to estimate the length of the image of the stick in the mirror (as if they were holding the tape measure directly up to the mirror). Here are the results:
The purple bars show their estimates of length (the sticks were of varying lengths; they’ve all been normalized to 1 for this illustration). The correct answer is shown with the arrows. As you can see, while responses were very accurate for the estimate of the physical stick, respondents thought the image of the stick in the mirror was much larger than it really was.
As a control, the researchers also held the stick directly against the mirror, and as you’d expect, the students could accurately estimate its length.
In a second experiment, the students viewed the sticks from two different viewpoints — 1.5 meters away from the mirror or 6 meters away (the sticks were always held directly over the viewers’ head). The same error was repeated, no matter how far away the observers stood from the mirror. The students were also asked a question similar to our first poll question: would the proportion of the mirror taken up by the stick increase or decrease as they moved away from the mirror? Most respondents said, incorrectly, that the proportion would decrease.
In two additional experiments, the researchers kept the sticks in the same place while asking the viewers to estimate their size and the size of their reflections. No matter how far away viewers stood from the mirror, their estimate of the size of the reflection didn’t change significantly, despite the fact that it changes considerably.
In several of these experiments, students also looked at the objects through a window (with the same relative distance to the physical object and its projection on the window). The results were similar (and the physical principles, in fact, are also essentially identical).
As this diagram shows, we’ll instinctively move closer to a window to see more of what’s outside:
If someone is the same distance from the window as we are, we can see their whole body even if the window is only half the size of the person we’re looking at — their image in the window is only half their actual size. But if we move away from the window (as in the bottom panel), we can’t see their whole body — their image as a proportion of the window has gotten larger.
Of course, if we’re looking at our own reflection, it’s impossible to be a different distance from the mirror as our reflection, which means the reflection itself is always half our actual size, and it doesn’t change, no matter how far we move from the mirror.