Information Sources for Investigation
Information Sources
Information relevant to a safety investigation can be acquired from a variety of sources, including:
a) Physical examination of the equipment used during the safety event. This may include examining the front-line equipment used, its components, and the workstations and equipment used by supporting personnel (e.g. ATCOs, maintenance and servicing personnel).
b) Documentation spanning a broad spectrum of the operation, for example:
- maintenance records and logs;
- personal records/logbooks;
- certificates and licences;
- in-house personnel and training records and work schedules;
- operator’s manuals and Standard Operating Procedures (SOPs);
- training manuals and syllabi;
- manufacturers’ data and manuals;
- regulatory authority records;
- weather forecasts, records and briefing material; and
- flight planning documents;
- aeronautical information publications.
c) Recordings (flight recorders, ATC radar / flight data and voice tapes, etc.). These may provide useful information for determining the sequence of events. In addition to traditional flight data recordings, maintenance recorders in new generation aircraft are a potential additional source of information.
d) Interviews conducted with individuals directly or indirectly involved in the safety event. These can provide a principal source of information for any investigation. In the absence of measurable data, interviews may be the only source of information. More importantly, interviews are often the only way to answer the important ‘why’ question, which in turn will facilitate the establishment of appropriate and effective safety improvement recommendations.
e) Direct observation of actions performed by operating or maintenance personnel in their work environment. This can reveal information about potential unsafe conditions. However, the persons being observed must be aware of the purpose of the observations.
f) Simulations. These permit reconstruction of an occurrence and can facilitate a better understanding of the sequence of events that led up to the occurrence, and the manner in which personnel responded to the event. Computer simulations can be used to reconstruct events using data from on-board recorders, ATC radar / flight data / voice recordings and other physical evidence.
g) Specialist advice. Investigators cannot be experts in every field related to the operational environment. It is important that they realize their limitations. When necessary, they must be willing to consult with other professionals during an investigation.
h) Safety databases. Useful supporting information may come from accident/incident databases, in-house hazard and incident reporting systems, confidential reporting programmes, systems for monitoring line operations (e.g. flight data analysis, Line Operations Safety Audit (LOSA) and Normal Operations Safety Survey (NOSS) programmes), manufacturers’ databases, etc.