By: address these concerns, the United Nations convened in 2015 to establish the Paris Agreement, a framework for reducing global greenhouse gas emissions and for slowing the global temperature increase. To date, 170 out of the 197 participant nations have ratified the Paris Agreement, which stands as the most comprehensive climate change framework that the United Nations has established to date (2).
Although the Paris Agreement has noble goals, some members of the scientific community worry that merely slowing down climate change will not be enough to prevent the environment from going “over the edge.” These individuals argue for the proactive implementation of geoengineering mechanisms to reverse some of the most crucial environmental changes that have taken place thus far. As defined by the 2010 United Nations Convention on Biological Diversity, geoengineering mechanisms include “any technologies that deliberately reduce solar insolation or increase carbon sequestration from the atmosphere on a large scale that may affect biodiversity” (2). Put simply, the general goal of geoengineering is to decrease the greenhouse effect. This same United Nations Convention published a moratorium that prohibits field testing of geoengineering techniques by any person; on the other hand, the moratorium allows for “small scale scientific research studies that would be conducted in a controlled setting” (2).
The obvious ambiguities of the United Nations’ geoengineering moratorium have prevented any serious enforcement of its policies. In 2012, American entrepreneur Russ George conducted a unilateral iron fertilization experiment off the coast of western Canada (3). One of the main purposes of this experiment was to determine if the influx of iron would help boost the phytoplankton population in the area, since iron is a vital nutrient for phytoplankton and other marine primary producers (3). Higher phytoplankton population is correlated with more photosynthesis, which translates to a greater intake of carbon dioxide from the atmosphere. So, the hypothesis in this case is that seeding the ocean with iron leads to greater sequestration and export of atmospheric carbon dioxide; this process should theoretically help reduce global temperatures over the long run by decreasing the amount of carbon dioxide in the atmosphere (3). George faced a considerable public outcry since he effectively violated the United Nations moratorium on geoengineering (3).
At this point in time, rather than concerning ourselves with the minutiae of international policy, it is much more meaningful for us to debate a more philosophical question: Is geoengineering the future of climate remediation? Geoengineering has only recently burst onto the scientific scene, and it presents a novel approach towards the long-standing issues of global warming and climate change. Below, we shall explore both sides of the debate and see how geoengineering fits into the evolution of science.
Advocates of geoengineering generally argue that efforts to simply slow down global warming have been fairly unsuccessful, thus necessitating proactive corrective action in the form of geoengineering. In a seminal paper, Dutch atmospheric chemist Paul Crutzen points out that global carbon dioxide emissions would need to be reduced by 60- 80% to achieve zero net emissions, which is largely unfeasible (4). Crutzen then discusses the merits of spraying sulfur dioxide (SO2 ) into the atmosphere, since SO2 is known to reflect solar radiation back out into space, thus counteracting the greenhouse effect brought about by CO2 (4). There is fairly convincing empirical evidence that corroborates Crutzen’s case: following the 1991 Mount Pinatubo volcanic eruption, which released 17 million tons (15.4 million metric tons) of SO2 , global temperatures dropped by about 0.6 ° C the next year.5 Although SO2 clearly can have a myriad of other side effects on the environment (e.g. acid rain), we see that it can potentially be a powerful tool for reversing the current trend of global warming, if we can find a way to harness it correctly. With temperatures increasing at their current rate, such techniques may very well become the only option to keep global temperatures at a sustainable level.
Opponents of geoengineering present a fairly strong case as well. One common argument is that geoengineering involves excessive meddling with the environment, which more often than not results in environmental damage. As alluded to previously, SO2 injection often results in acid rain, which arguably has far more detrimental effects on the environment than potential benefits. With regard to iron fertilization in oceans, some geoengineering skeptics point out that massive phytoplankton blooms often form around seeded areas, disrupting the balance of the local food chain and sapping other vital nutrients from the waters (3). A second oppositional argument involves the notion of a moral hazard.6 Generally speaking, a moral hazard is where someone develops a solution to a problem, yet the presence of the solution makes people think that they no longer need to care about the problem and can behave as unscrupulously as they please.6 In the case of geoengineering, the moral hazard would be that if the general public becomes convinced that geoengineering can resolve all environmental issues, then the public will no longer care about using sustainable practices, since they will think that geoengineering can reverse all future damage that is done to the environment. This moral hazard argument generally would come into play at the policymaking stage, since lawmakers would now need to decide how to regulate geoengineering practices.
We thus continue to observe a spirited debate about the merits of geoengineering. This field holds immense promise and should be explored; however, the scientific community must take calculated steps to make sure that geoengineering’s power is harnessed in a manner that is beneficial on the whole to all stakeholders. Going forward, we can expect to see more discussion and exploration of geoengineering in the scientific community, as global warming continues to steadily progress.
Sandip Nirmel ’21 is a freshman in Thayer Hall.
WORKS CITED
[1] Dahlman, L. Climate Change: Global Temperature.. gov/news-features/understanding-climate/climate-change-global-temperature (accessed Sept. 24, 2017).
[2] Convention on Biological Diversity. Climate-related Geoengineering and Biodiversity. climate/geoengineering/ (accessed Sept. 24, 2017).
[3] Fountain, H. A Rogue Climate Experiment Outrages Scientists. The New York Times [Online], Oct. 18, 2012.. com/2012/10/19/science/earth/ iron-dumping-experiment-in-pacific-alarms-marine-experts.html (accessed Sept. 24, 2017).
[4] Crutzen, P. Climactic Change 2006, 77, 211-219.
[5] Harpp, K. How Do Volcanoes Affect World Climate? Scientific American [Online], Apr. 15, 2002. https:// how-do-volcanoes-affect-w/ (accessed Sept. 24, 2017).
[6] Fairbrother, M. Climactic Change 2016, 139, 477-489.