The latest IPCC special report discusses the potential impacts of global warming of 1.5 °C and presents several pathways scenarios but without focusing much on the need of protecting and sustainably managing the forests we currently have.
You have probably heard or read that during the last days the IPCC – the Intergovernmental Panel on Climate Change – issued a new report evaluating the impacts of 1.5°C of global warming. I read several posts and opinion on this, and I was also positively impressed by the fact that the results of the report have been discussed in the front page of many medias. However, when I looked at the document I found myself slightly disappointed because I frankly expected it to strongly highlight the role of forests as the main ‘weapon’ to sequester carbon from the atmosphere, as well as the importance of using sustainably yielded forest products for stocking carbon in form of long-lived products, such as wooden buildings and structures.
The document calls for drastic actions that human societies should undertake to reduce the effects of climate change. Among them, it mentions the use of bioenergy products, forest restoration and large-scale replanting, as well as the need to capture and storage carbon from the atmosphere using new technology – so called Bioenergy with carbon capture and storage (BECCS). However, it seems to me that the report minimizes the impact healthy forests and sustainable forest management can have in the battle against global warming and increasing CO2 emissions. Instead, multiple scenarios were presented in which negative emission technologies are applied making a large use of BECCS. Only the first scenarios consider afforestation alone as the main option for Carbon Dioxide Removal (CDR).
Recently, I stumbled upon an interesting article on negative emission technologies, discussing that to really make an impact against the tonnes of CO2 emitted every day, negative emission technologies “must be shown to work on a gigaton scale, at an affordable cost, and without serious environmental impacts”. Nevertheless, that has not happened yet because, among others, the costs of direct air captures, which so far have been tested only at small scales, are on the order of hundreds of dollars or more per ton of CO2. Essentially, we are far way from their massive implementation at global scale.
I am hoping that negative emission technology will soon be an affordable and widespread reality, but at the current time we only have one proven natural technology that works for removing and storing atmospheric CO2 at planetary scale: forests. And I am not talking only about planting new forests or restoring patches of forests where previously harvested. I also include sustainable forest management and strategic actions that are needed to maintain healthy forests ecosystems. This, I believe, is what was missing from the IPCC report. Not only the fact to avoid deforestation and increase afforestation but improve the management of forests so they would be more resistant and resilient to disturbances (e.g., forest fires) know to suddenly release large amount of carbon to the atmosphere.
To increase this awareness, a pool of forest scientists prepared a response letter to the report pointing out that many of the technological carbon-capture solutions reported in the latest IPCC report are unverified, while forest sequestration is a well known and proven technology to fix atmospheric carbon in biomass and soils. The letter also remarks that “bioenergy as such is not the primary solution because achieving significant amounts of carbon dioxide removal through use of wood for energy and capturing the resulting carbon in geological reservoirs requires technology that is untested at large scale”. And I totally agree with that! The use of wood and other biomasses for heating and energy production is certainly a way to go, but as many studies shown they are not fully carbon neutral (and in some cases, such as the transport of wood pellets from where is produced in America to the household stoves where is burned in Europe, production and transport costs cause higher carbon emissions than conventional methods).
This letter concludes that “we must protect and maintain healthy forests to avoid dangerous climate change and to ensure the world’s forests continue to provide services critical for the well-being of the planet and ourselves”. For this reason, I would have loved to see different IPCC scenarios for different levels of forest management worldwide, and not only considering afforestation as CDR option.
No doubt that this IPCC report, together with the Paris Agreement, represents a turning point in the acknowledgement of the potential, devastating impacts of human induced climate change around the world. However, I hope that next time the role of forests and of sustainable forest management will be in the front page.
As a forest scientist, I believe we should keep working on increasing the awareness and application of climate-conscious forest management strategies. Most importantly, I think that management actions should be harmonized within forest landscapes across the globe, therefore it is crucial seeing forests with a multi-scale perspective, from tree to landscape. We also should not forget to favor the use of sustainable timber and their by-products for building structure and long-lived products.
Useful links consulted for this post:
- IPCC Special report on the impacts of global warming of 1.5 °C
- Five Reasons the Earth’s Climate Depends on Forests – The Climate and Land Use Alliance
- Forests’ Role in Climate Security – post by Frank Lowenstein from the New England Forestry Foundation
- Climate change: 1.5°C is worth striving for – but is it feasible? – post by Arthur Petersen in The Conversation
- IPCC 1.5℃ report: here’s what the climate science says – post by Keith Shine in The Conversation
Main photo: A fragmented forested landscape, in which management decisions can greatly influence the role of the forest in stocking carbon. Source of the photo: pixabay.com
One thought on “Were forests not taken seriously enough in the last IPCC 1.5° report?”