The past several years my desktop machine at work has been running 32-bit Ubuntu (and more recently Xubuntu), even though it had a 64-bit processor. The nature of the work I did meant that this wasn't really an issue at all until recently an application that did require interaction between the desktop client and the HPC cluster dropped support for the 32-bit client. Well, fair enough. But what 64-bit distribution should I install? "Slackware", said the mischevious wonk next to me. Sure. Why not? After all, it was the first Linux distribution, and it has slack in the title - and I do believe in the benefits of the Church of the Sub-Genius. Actually there are two reasons why not, but I thought I'd give a whirl anyway.
Installation was pretty much as documented. You will have to do your own partition management, a typical rule of either partitioning /boot, /home, and a swap partition is pretty sensible. Or you can just put everything under / and work it out later if that way inclined (I was, and I shouldn't have been). When it comes to installing packages, it's worth going for "full", keeping in mind one of the aforementioned "two reasons", although there is a very good argument from older-style Slackware purists that says that you should have full knowledge of your system at all times and shouldn't beholden to pretty stupid niche situations, such as a media player wanting Samba as a dependency.
/boot
swap
/
After that it's a case of getting LILO set up as the boot-loader (I had to run liloconf after the install due to some interesting arguments with an existing GRUB) and the default window manager (my preference is XFCE). Like most things Slackware, options which are expected and normal in most distributions are not necessarily the case with Slackware; in particular it is noted that 64-bit Slackware really means 64-bit. It will not run 32-bit binaries. To enable this there is some fairly straight-foward instructions.
One item of the install instructions that I shouldn't have followed was the recommended character encoding which is LANG=en_US. Whilst it is true that Slackware is playing it safe here, I have so many documents in UTF, it proved to be a bad choice for me. There are two suggestions here; first change /etc/lilo.conf by adding append="vt.default_utf8=1 in the Linux bootable partition config. The second is modifying /etc/profile.d/lang.sh and removing the comment marker for export LANG=en_US.UTF-8 and adding on for export LANG=en_US. A reboot will also be necessary as lilo.conf has been modified.
LANG=en_US
/etc/lilo.conf
append="vt.default_utf8=1
/etc/profile.d/lang.sh
export LANG=en_US.UTF-8
export LANG=en_US
An annoying bug discovering post-install, and a very critical bug for those who enjoy listening to some tunes whilst slaving away on a hot cluster (they do get hot, btw), concerned with how alsa was setting default sound devices.
Earlier on two reasons were mention on why a person may not wish to use Slackware. These are the lack of GNOME as a desktop option and the lack of dependency management. The former was due the difficulty of getting GNOME to be built from scratch (true, but ironic coming from Slackware). I didn't really think I would miss GNOME, being more of a command-line warrior, but there was just a few applications which I have missed. These include Gedit (as much as Kate is a reasonably good alternative), the oft-maligned Nautilis, Evince (certainly better than XPDF, especially with some larger document, or KDE alternatives like Okular), or even EotG. A download and installation of LibreOffice was almost immediate after opening one document with Calligra. These are, of course, mostly choices based on aesthetic preferences and habit. Without a doubt others will have different tastes, and apparently if one wishes to make the effort, there is a complete GNOME Slackbuild, although that would require a downgrade from my current install; as their instuctions say: If you are trying to build GSB on systems other than the above you will encounter problems during the build.
If you are trying to build GSB on systems other than the above you will encounter problems during the build
The other reason that people may not be inclined towards Slackware is the lack of automatic dependency resolution with packages. With Slackware you get the binary as the developer provided, with the absolute minimum number of changes (e.g., adding .desktop executables). Unlike other distributions, where the source code is modified to fit their own distributions, with Slack you get what the author intended. For Slackware advocates this means that the packages are secure and accountable, without automatic dependency resolution (and typically installation) avoided. The advocates are right of course; Slackware didn't suffer from the Debian SSH bug, but from the perspective of most users that was solved with a simple update, whereas installing anything new on Slackware usually does require working one's way through the various dependencies. Yes, it does teach good systems knowledge, but if you already are aware of packages and dependencies, it's more of an "interesting nuissance". This said the package tools that come with Slackware (pkgtools, slackpkg) do exactly what they say on the lid.
Overall, Slackware is not as scary as some might have you believe, but it's not for beginners either. It does come with excellent documentation to help you on your way. It does require a bit of experience, a bit of forethought, and a desire, well, to be slack. You are best off with Slackware determining quite early on what you want your system to do, and sticking to it. For my own line of work this is fine; for others, and certainly for home users, perhaps think again.