What is beta-alanine?
Beta-alanine is a non-essential amino acid, meaning it is naturally occurring within the human body. Unlike most amino acids beta-alanine is not involved in protein synthesis, it is used to help produce carnosine that is stored in the muscles and has a role in reducing lactic acid build-up during high intensity exercise (Harris et al. 2006).
Does beta-alanine make you run or cycle faster?
As a result of its involvement in producing carnosine to buffer lactic acid, consuming beta-alanine can lead to enhanced sports performance (Saunders et al., 2017). Levels of beta-alanine in your muscles are usually relatively low and therefore the typical production of lactic acid buffering carnosine is limited. Taking on beta-alanine elevates levels in the muscles and therefore increases the production of carnosine (e.g. Harris et al. 2006) to buffer more lactic acid.
How does beta-alanine benefit sports performance?
During high intensity exercise glucose is rapidly broken down, via the process of glycolysis, to quickly produce energy, however the downside of this anaerobic glycolysis is the production of the by-product lactic acid. The body breaks lactic acid down in to lactate, producing hydrogen ions in the process. Hydrogen ions increase the acidity of the muscles and reduces their pH level. Increased muscle acidity starts to hinder further metabolism of glucose, decreasing the energy production capacity of the muscles and resulting in fatigue (Powers & Jackson 2008). Carnosine can buffer the acidic build-up associated with high-intensity exercise and as beta-alanine increases carnosine it helps to reduce fatigue (Harris et al. 2006).
Muscle acidosis typically limits performance during high-intensity exercise and for that reason beta-alanine specifically helps reduce fatigue during short-duration exercise lasting one to several minutes (e.g. Hill et al. 2007; Sale et al. 2010). This makes the use of beta-alanine ideal for sprinting or track and field, pool-based swimming events, team sports and other high intensity disciplines. There is further evidence that beta-alanine helps to increase the time to exhaustion during endurance events (Santana et al., 2018).
Beta-alanine and cycling performance
Beta-alanine has also been shown to improve sprint performance at the end of an endurance cycling race (Van Thienen et al. 2009). This means if you take a Beta Blast Pocket Rocket towards the end of your event, you’re likely to see improvement in your sprint finish therefore with beta-alanine cycling endurance will be improved. Based on this logic beta-alanine can improve finishing speed in running events too.
When to use beta-alanine
Beta-alanine is a popular pre-workout nutrition supplements. Taking beta alanine pre-workout can increase the intensity at which you can train or compete, or increase the duration at which you can maintain a given high intensity. Consuming a Beta Blast Pocket Rocket energy bar directly pre-race or before training or will give you the perfect lactic acid buffering boost you need to power through your workout or event.
How much beta-alanine to take
With each Beta Blast Pocket Rocket containing 2g of beta-alanine, two bars will satisfy the widely accepted beta-alanine daily dose of 2–5 grams. If you’re doing a longer duration endurance event a Pocket Rocket Beta Blast energy bar prior to a certain high-intensity section (usually the finish) will also be beneficial.
Does beta-alanine give a tingling sensation?
Be aware of the ‘beta-alanine tingling sensation’… Don’t be alarmed but beta alanine can cause a slight tingle when eaten which is completely normal. Beta-alanine is considered to be a safe and effective supplement to boost exercise performance.
REFERENCES
Spriet LL, Lindinger MI, McKelvie RS, Heigenhauser GJF, Jones NL. Muscle glycogenolysis and H+ concentration during maximal intermittent cycling. J Appl Physiol. 1989;66:8–13..
Santana JO, de Freitas MC, dos Santos DM, Rossi FE, Lira FS, Rosa-Neto JC, Caperuto EC. Beta-Alanine Supplementation Improved 10-km Running Time Trial in Physically Active Adults. Front Physiol. 2018;9:1105.
Saunders B, Elliott-Sale K, Artioli GG, Swinton PA, Dolan E, Roschel H, Sale C, Gualano B. Beta-Alanine supplementation to improve exercise capacity and performance: A systematic review and meta-analysis. British Journal of Sports Med. 2017 Apr; 51(8):658-669.
Powers SK, Jackson MJ (2008) Exercise-induced oxidative stress: cellular mechanisms and impact on muscle force production. Physiol Rev 88:1243–1276
Sale C, Saunders B, Harris RC. Effect of beta-alanine supplementation on muscle carnosine concentrations and exercise performance. Amino Acids. 2010;39:321–333.
Van Thienen R, Van Proeyen K, Vanden Eynde B, Puype J, Lefere T, Hespel P. Beta-alanine improves sprint performance in endurance cycling. Med Sci Sports Exerc. 2009;41:898–903.