An introduction to our Health Promotion Practitioner Register – part of the IUHPE Health Promotion Accreditation System
By David Kidney, UKPHR Executive Director & Dr Viv Speller, UKPHR Director and Member IUHPE Accreditation Committee
At UKPHR we have launched a new register, alongside our long-running public health register, for health promotion practitioners specifically. We want to explain the new register and why we believe that this register will be suitable for some people who are studying for or working in health promotion careers.
The International Union for Health Promotion and Education (IUHPE) is at the forefront of a global mission to promote quality assurance, competence and mobility in Health Promotion practice, education and training globally.
IUHPE’s Health Promotion Accreditation System .
As IUHPE’s National Accreditation Organisation in the UK, we operate a Health Promotion Practitioner Register. In this article we will call this new register the “IUHPE-accredited register”.
This IUHPE-accredited register is separate from our accredited register for public health specialists, public health practitioners and Public Health Specialty Registrars. This already well-established UK public health register is accredited under a statutory scheme by the Professional Standards Authority and in this article we will refer to this, which includes our public health practitioner registrants as the “PSA-accredited register”.
Through registration, health promotion practitioners in the UK make a commitment to quality Health Promotion practice based on agreed competency-based criteria. Registration justifies use of the title ‘IUHPE Registered Health Promotion Practitioner’.
Registration makes practitioners part of a worldwide community because registrants’ names are also added to the IUHPE Health Promotion Accreditation System Global Register. This should make the new register attractive for international students currently in the UK and UK health promotion practitioners who may be considering pursuing their careers elsewhere in the world. Currently Ireland, Australia and Estonia have adopted the IUHPE Health Promotion Accreditation System, and New Zealand is in the process of development.
Benefits of registration include:
- Increased recognition and visibility of Health Promotion qualifications,
- Facilitation of career movement across roles, organisations, regions and countries,
- A reference point for employers in recruitment and selection.
In the UK we are offering three categories of accreditation for health promotion practitioner applicants who can apply for registration on the IUHPE-accredited register:
- Graduates from courses accredited by the IUHPE System;
- Applicants who are not graduates of an accredited (accredited by IUHPE System) course; and
- Public health practitioner registrants on the PSA-accredited register.
Graduates from courses accredited by the IUHPE System will be automatically eligible for registration on the IUHPE accredited register upon proof of graduation.
Applicants for registration on the IUHPE-accredited register who are not graduates of an accredited course will be required to:
- Have a relevant undergraduate (Bachelors) degree. Graduates from a range of relevant courses, including public health, health promotion, health education and social sciences including psychology, epidemiology, sociology, education, communication, environmental health, community, urban or rural development, and political science, will be eligible to apply. Other academic qualifications may also be deemed appropriate on assessment, and a list of all previously accepted graduate qualifications will be maintained for future reference;
- Undertake self-assessment in accordance with the pro forma prescribed by IUHPE;
- Demonstrate 2 years’ of having been working in the field of health promotion.
Public health practitioner registrants on our PSA-accredited register are required to demonstrate 2 years’ experience of having been working in the field of health promotion. The reason why applicants who are public health practitioner registrants on this PSA-accredited register are exempt from the other requirements is that they will already have undergone a detailed assessment of a portfolio of evidence demonstrating their competence in public health practice at an appropriate level (autonomous practice).
Public health practitioner registrants on the PSA-accredited register will not be required to pay a second registration fee if they decided to achieve registration on both registers.
An assessment fee is payable by those applicants who submit the self-assessment questionnaire. We will arrange the assessment.
We will charge all applicants, including public health practitioner registrants on the PSA-accredited register, a one-off administration fee for processing their applications.
Registration on the IUHPE-accredited register will be for a period of 3 years, and can be renewed subsequently. Registrants on the IUHPE-accredited register will initially be required to pay a triennial registration fee, and UKPHR will exempt public health practitioner registrants on the PSA-accredited register (for so long as they maintain that registration) from having to pay this fee.
Health promotion and health improvement are vital elements in the delivery of a comprehensive and holistic public health service. Health promotion practitioners make a significant contribution to society’s efforts to improve the health and wellbeing of populations and to reduce inequalities.
We support health promotion practitioners in the work they do and by opening this new register we hope to encourage health promotion practitioners to register and join what is a growing national and international community of like-minded professionals. We believe that the public and public health employers and commissioners of public health services and interventions will be assured by and will benefit from this registration system.
Our register will help health promotion practitioners to demonstrate their skills, knowledge and experience through registration. Registrants will, through their registration, be making a public commitment to maintaining and enhancing their competence after initial registration, for example through CPD (Continuing Professional Development) learning.
If you are a committed and enthusiastic and determined health promotion practitioner, we look forward to receiving your application for registration soon.