Analysis: cut in dividend may sound a warning to APMM investors
It is my view that we have heard lots of promises and little else, although these promises need time – years, possibly – before they bear fruit.
However, time is one thing that Maersk has at its disposal, based on its recent financial performance and cash balances, despite the challenging end markets for most of its business lines.
Waiting game
So here’s a soft warning to all those corporate executives, suppliers and investors who are bullish about organic growth backed by rising rates in the container shipping industry. Many I have talked to are genuinely bullish in their belief that equity and operational risk are manageable within Maersk Line, the main value-driver of the group.
to be a record year for M&A in container shipping.
It is important to consider that, if you have followed Maersk’s recent corporate action, you would realise that if its equity value doesn’t hold up at around its current level – or even falls, it will hinder its negotiating power, let alone its ability to use stock as M&A currency in future deal-making.
Acquisitions, of course, will continue to be a key component in its corporate strategy following the purchase of its German rival, which recently received the green light from the European Commission – and that means that any mis-steps in corporate strategy could cost it dearly.
Tiptoeing
First-quarter results released this month clearly pointed to improved cash flows on a year-on-year comparable basis, but rising cash flows have not risen enough to cover core investment needs, while cash balances were down significantly, and net debt – up by $1bn since the end of the fourth quarter of last year – continued to soar.
In the first quarter, it churned out more cash from operations than a year ago, while reducing heavy investment by about $600m to $1.2bn, which partly benefited its daily cash-burn rate. Nonetheless, it burned about $4m for every day during the period, based on $376m of negative free cash flow in the first quarter.
In its results presentation, APMM emphasises that 2017 and 2018 are years of transition, but its shares continue to defy the law of gravity – indeed, its current share price seems to suggest there’s no short-term risk here.
But success breeds complacency, and this breeds failure. And in the precarious world of finance, one bad quarter is all that’s needed to change the risk perception towards Maersk and its plan, harming its ability to count on a strong equity valuation, so important when it comes to managing expectations of customers and investors, as was so recently in evidence during the Yang Ming saga.
In Copenhagen, management talked of a “gradual improvement for Maersk Line”, which has problems in steeply rising bunker costs; APM Terminals was described as facing “challenging market conditions”; after a genuine turnaround, Damco’s “forwarding margins are under pressure”; APPM’s drilling operations continue to focus on “costs savings and operational performance”; and, finally, smaller units such as Supply Services, Tankers and Svitzer fared worse than a year earlier.
One bright spot was Maersk Oil, although most of the surge in its reported profit, to $328m (versus a first-quarter 2016 loss of $29m), came as a result of a massive reduction in operating costs, down to $389m in the first quarter from $560m one year earlier, and a one-off benefit in tax income of $24m.
An outlier was Maersk Container Industry (MCI), which enjoyed different dynamics based on its new production capabilities following the full launch of its new factory in Chile, catering for increased demand from third parties for its StarCool reefers and the associated software developed to support the technology. However, the picture MCI offered was generally unchanged from 2016, based on return on invested capital, which is a key gauge of efficient capital deployment.
APMM’s quarterly results do not warrant a granular look at the financials of each division in isolation, because it is more important to understand how its vast assets base is currently working in unison, given that good and bad assets might have to sit under the same umbrella for quite a long time before a formal separation of transport and energy occurs.
It is possible that Maersk’s management is preoccupied by the possibility of impairments and one-off charges deriving from a formal break-up of the group, which could imbalance its net worth, or equity capital, eventually requiring a cash call to shore up its capital structure. After all, it’s relatively easy to hide losses under its current conglomerate structure, and that could be a reason why it didn’t reach agreement with DONG Energy to merge certain oil and gas assets in the past – although DONG itself appears to be undergoing a strategic transformation.
It is far too early to say if one-off items will prevent a full break-up, but another issue here is the paucity of eager buyers. This is a dreadful market for sellers looking to offload capital-intensive assets to trade buyers, while the public market route is also tricky as investors are wary of the risks associated to committing to any story where cyclicality could sink their returns.
Which, all in all, leads me to think that “New” Maersk could very well end up looking just like “Old” Maersk.
Warnings
Cash balances are falling fast, yet its overall “liquidity reserves”, as Maersk labels cash in hand and certain credit facilities, are reassuring, although uncertainty reigns about its future plans. And one event in particular testifies to a difficult situation where Maersk does not want to commit to sticking to any particular promise – a dividend cut that emerged in early February.
A year earlier, Maersk paid out an ordinary dividend of Dkr300.
Back in February 2016, I warned income seekers that dividend risk was apparent through to 2017, and this is now my second warning for investors who want capital appreciation: its stock market value is out of whack with reality, especially considering that capex projections imply heavier investment for the reminder of the year, based on guidance of between $5.5bn and $6.5bn.