Investors have to pay taxes on payments received from income investments.
Ryan McVay/Photodisc/Getty Images
For all of its benefits, income investing does have some drawbacks that investors should prepare for. Investing offers no guaranteed returns, and financial securities that produce income are no exception to that rule. If that steady stream of payments abruptly stops, investors could be left with no income. Public policies that affect the payments from income investments can change, and if investors are not aware of these, they could see their profits dwindle.
Overview
Income investments are not limited to a single asset class. In the stock market, companies that pay ongoing dividends are grouped among income investments. In addition to dividend-paying stocks, real estate investment trusts (REITs) are a form of equity investments that trade like stocks but have some different features. REIT issuers are required to pay investors dividends from the income they earn from properties. Fixed income securities, or bonds, are among the most common form of income investments. Bonds provide income through interest payments made on the debt securities.
Returns
Investors hoping to earn short-term profits in the financial markets generally cannot achieve this with income investments. In fact, one of the risks with dividend stocks in particular is that their market values, or stock prices, do not increase as much as other stocks. This is because income stocks use their profits for dividends instead of using extra cash to reinvest in the business, and this can slow sales and earnings growth, according to a 2012 article on the "Wall Street Journal" website.
Risks
Inflation is one of the primary risks that bond investors face. Rising inflation in an economy diminishes the value of a bond's principal amount, which weakens the buying power of an investor's returns, according to a 2012 "Kiplinger" article. For REIT investors, erratic price movements are a primary risk. Although REITs are income investments, they trade much as stocks do in the equity markets and are susceptible to the same stock market volatility that equities experience.
Interruptions
Income investing is supposed to lend some stability to an investment portfolio. Nonetheless, that security can vanish in the event that a bond or dividend issuer can't continue making payments. Even companies that pay some of the most generous dividends can experience hardship. For instance, during the economic recession in 2009, almost half of the top dividend payers interrupted those distributions for that year, according to a 2012 article on the Fidelity Investments website.
Video of the Day
References (3)
Resources (2)
Photo Credits
- Ryan McVay/Photodisc/Getty Images