[ UniNews Vol. 14, No. 11
27 June - 11 July 2005 ]
By Gabriele Lakomski
What is the role of a leader in an organisation? How is it that organisations can survive and function well at times apparently without a ‘leader’?
According to University of Melbourne academic Professor Gabriele Lakomski (right) traditional understandings of leadership do not really explain how organisations function. In a new book, Managing without Leadership, Professor Lakomski challenges orthodox thinking about leadership and critically examines leadership theories, past and present. She outlines here the broad ambit of her investigation and proposes directions for further research in pursuit of understanding how organisations accomplish their goals.
There is no question mark after Managing Without Leadership. This omission might strike some readers as inappropriately dogmatic and prematurely final. Yet the decision not to leave the issue of whether we can manage without leadership open was a simple one: we do. Organisations keep performing whether they have a strong leader, a weak leader, or no leader at all.
Every one of us lives in some form of organisation. We all know from everyday experience that organisational work takes many heads and hands, and that those at the top often do not know much of what goes on below, given the size and complexity of the organisation.
Goals ordered from above look different when they reach the shop floor and have to be de-coded and translated into the work contexts of those whose job it is to carry them out. In short, organisations are complex beasts whose functioning is poorly understood; no one person has a complete overview of what happens, and efficiency and effectiveness, where it is had at all, requires an army of interconnected brains, hands, and artefacts to accomplish.
None of this denies the existence of the exceptional Chief Executive Officer, the formal office holder who possesses what are identified as leadership qualities by some theoretical model. Of course these gifted individuals do exist, or the idea of leadership would not have got off the ground in the first place. What is at issue is the causal link drawn between individual abilities and organisational outcomes. Its acceptance is implicit, but fundamentally misplaced.?
Where do we get the idea that ‘leadership’ is the right explanation for the organisational phenomena we encounter? There is a discrepancy between the ways in which members believe that their work places operate and how theories of leadership account for organisational functioning.
If I had to nominate one overarching objective for this project, it would be the development of a causal, bottom-up account of organisational practice, in place of top–down theories of leadership that are incapable of accounting for the specificities of individual experience, because these are always generated and bound by the nature and conditions of their contexts.
Such an enterprise is bold, but I argue that asking how organisations really work, and how we account for ongoing organisational practice, are questions broader in scope than those concerned with the purported effects of leadership. Furthermore, they do not assume a priori that leadership is an answer, let alone the answer to effective organisational functioning. My claim is that it is not.
My approach is to redescribe what is termed ‘leadership’ and to argue for better, theoretically and empirically justified ways of understanding organisational practice. By redescribing I have in mind a process common in the history of science where the description of an observed phenomenon is replaced by a better one, on the basis of the best currently existing knowledge.
I propose that we consider the phenomenon of leadership in like manner, and conceive of it as part and parcel of organisational practice. In a naturalistic redescription of the phenomenon, we might view it as an emergent, self-organising property of complex systems. There would then be no need for engaging in more leadership studies: instead, we could redirect our attention to the study of the fine-grained properties of contextualised organisational practice.
A better understanding of how we do what we do in organisational settings, shaped by our interactions with tools and artefacts of our own making, holds the key to improving organisational efficiency and effectiveness. This I propose as the research program to guide organisational studies into the future. My contribution to such an enormous enterprise is to map out the theoretical contours that might help us get there, and to offer some suggestions on where to go ‘after leadership’ in a discussion of some central current organisational topics.
Managing Without Leadership is part of a research program that Colin Evers (University of Hong Kong) and I have pursued in three original texts, Knowing Educational Administration, Developing Educational Administration, and Doing Educational Administration, as well as in various other publications. Managing Without Leadership is conceived as an extension of the basic ideas developed in these foundation texts.
Simply put, we think that if administration theorists wanted their claims to be valid, these have to be supported by evidence.
Two requirements act as a kind of theoretical pincer movement to establish the coherence or incoherence of claims made for leadership: evidence must be provided for claims, and features or skills supposed as characteristic of (or essential to) leadership or leaders have to be learnable.
Advocates for the existence and necessity of leadership assume more than they can deliver given their own theoretical resources, and given that organisations seem to manage perfectly well to accomplish their goals regardless of who is at the helm, the causal nexus between leadership and organisational practice is difficult to sustain. The move to studying how we think and act in practice, and how we learn, promises a better empirical understanding of how organisations accomplish their goals.
Connectionist neuroscience provides the most up-to-date empirical knowledge on how we humans transport ourselves in our environments. Such exploration throws new light on how to understand organisational knowledge, on what it means to speak of ‘managing’ knowledge, if it makes any sense at all, and on whether the standard way of conceptualising the ebb and flow of organisational knowledge as knowledge transfer is defensible. These are issues of enormous complexity and scope.
Managing without Leadership maps out some original considerations for developing a naturalistic theory of organisational functioning, in relation to some central current issues in organisational theory. It breaks radically new ground: by proposing an explanation of human practice that is consistent with our knowledge of how creatures such as ourselves successfully manoeuvre in environments of our own making such as organisations – the quintessential manifestation of the out–sourced human mind. Leaders are just part of the bigger picture.
Professor Gabriele Lakomski is based in the University of Melbourne’s Centre for Organisational Learning and Leadership in the Faculty of Education.
Managing without Leadership: Towards a Theory of Organisational Functioning, by Gabriele Lakomski (Elsevier January 2005). 160pp, HB, RRP $138.00.
[ Photo: Paul Richiardi ]
Contact the University : Disclaimer & Copyright : Privacy : Accessibility
Date Created: 24 June 2005
Last Modified: 19 March 2007 16:23:48
Authorised By: Manager, Media and Publications Services Office
Maintainer: Ben Hider
The University of Melbourne ABN: 84 002 705 224
CRICOS Provider Number: 00116K ( More information )
Course Enquiries