Business mileage deduction can mean a fairly big amount of money (approx. $12,000) at the end of the tax year if you drive your own car for business purposes. You can always claim mileage on your taxes if you know how to keep track of mileage with mileage logs.
What are mileage logs?
“You should keep the proof you need in an account book, diary, log, statement of expense, trip sheets, or similar record. You should also keep documentary evidence that, together with your record, will support each element of an expense.” says the IRS.
The example picture that they provide looks like this:
When do you need to keep a mileage log?
- In the case of tax refunds for personal cars, the business/personal use ratio must be supported by a mileage log, and the tax can be refunded proportionally after the business part. Up to 90 – 100% can be reclaimed with mileage logs. However, we recommend a maximum of 80% – 20% business-personal use ratio, as anything above 80% is a red flag for IRS auditors.
- Business owners (independent contractors, freelancers, consultants, sole proprietors, partners in a partnership, and members of limited liability companies that are taxed as disregarded entities) are required to keep a mileage log if deducting the expenses of their vehicle used for economic activities.
- For businesses operating company cars, they are required to keep a mileage log, this, however, depends on the state your business is operating in. Nonetheless, practice shows that it is recommended to keep a mileage log to prove expenses, as the IRS often asks for it.
Mileage logs have formal requirements, therefore to claim a tax deduction for the business use of your car, it is important that it contains specified information.
According to the IRS, your mileage log must include a record of:
- the total mileage you drove in the tax year for business, commuting, and personal driving other than commuting,
- the first odometer or the last odometer reading of the year,
- the dates of your business trips,
- the address of the business partner you’ve visited,
- and the purpose of your trips.
The best choice to keep track of mileage for taxes is to have a contemporaneous mileage log.
Let’s take a look at some frequently asked questions about mileage logs and the related documentation!
- Do I need to collect refueling receipts when driving a company car?
We recommend keeping the receipts every time you fill your car! Even when you go on vacation by car, don’t lose the receipts, as they are one of the bases when creating your mileage log. We call them “fixed points“, as the safest way to create an IRS-proof mileage log is to build the travel itinerary around these unchangeable components. The reason for this is that the IRS can ask for supporting documentary evidence (e.g. filling bills) in the case of an Audit and the dates of fillings in your mileage log have to match with the ones indicated on the receipts.
- How often do I need to record my odometer readings?
In all cases, the mileage log should be kept in monthly blocks, however legally you’re required to record your annual odometer reading at the beginning of the year. In practice, it is worth recording them monthly to justify the tracked mileage you put in your mileage log.
- What kind of record should be kept of personal trips?
Many fall into the mistake of not recording personal trips. Yet you have to keep just as detailed records of them as you would do in case of business trips.
- What are the consequences of incorrectly kept mileage logs?
If you aren’t able to satisfactorily prove your mileage claims the IRS penalty for claiming business miles without a mileage log is $1000 or 50% of your income!
Tip: instead of 100% business use, I recommend everyone to have an 80-20% business – personal use ratio (unless you can prove 100% business use)!
- What is the best way of keeping track of your mileage?
The MileageWise mileage tracker app only uses your data when you arrive at your destination, recommending the parameters with which the trip should be saved and automatically creates the driven distance and route after the trip ended. No real-time GPS tracking needed. All the fuss with using up all your data for the month in the process, and killing your phone’s battery, disappears.
With the MileageWise Web Dashboard, if you’re worried that the end of the 2021 tax year is near: worry no more! Create as much retrospective log as you want to, and we make sure with the AdWise feature, which auto-populates your former trips and the Built-in IRS Auditor, which checks 70 logical conflicts (also monitoring the applicable legislation in that period) that your recommended logs are good to go and IRS-proof, meeting every expectation.
MileageWise saves your mileage logs securely in the cloud, so you never have to worry about losing them.
In summary:
For tax deduction claims – you’re required to keep a monthly mileage log.
Keep the receipts, record your odometer monthly – the IRS can ask for supporting documentary evidence.
Penalties are high – but deductions are high as well. So take care of your mileage logs.