Abstract
Background: Exercise and weight loss have been shown to improve serum testosterone (T) in obese individuals. However, the association between low T levels and guideline-based exercise thresholds has not been determined. Objective: Using the recently updated Physical Activity Guidelines Advisory Committee (PAGAC) recommendations, we sought to investigate the relationship between recommended activity levels and the prevalence of low T levels. Materials and Methods: The2011-2016 National Health and Nutrition Examination Survey (NHANES) was used to identify men ages 18 to 80 years who answered the physical activity questionnaire and underwent serum T testing. Men were categorized based on PAGAC activity level: less than recommended, recommended and greater than recommended. Multivariable logistic regressions were used to determine the association between low T (<300 ng/dL) and activity level across body mass index (BMI) categories while adjusting for potential confounders. Results: Of the 7372 men who met the inclusion criteria, the majority (4372, 59.3%) exceeded the recommended amount of activity, whereas only 2326 (31.6%) exercised less than the recommended amount. On multivariable analysis, obese men whose activity exceeded the recommended amount were less likely to have low T (OR 0.523, 95% CI 0.409-0.669, P <.001) compared with men who did not meet the recommended activity level. Discussion and Conclusions: Using a large, nationally representative cohort, we demonstrated that obese men whose activity exceeded PAGAC recommendations had a decreased likelihood of having low T levels. Given the numerous benefits of exercise, these data provide a basis for counseling obese patients regarding the association between exercise and decreased prevalence of low T.
Keywords
- NHANES
- exercise
- hypogonadism
- metabolic equivalents
- testosterone
ASJC Scopus subject areas
- Endocrinology, Diabetes and Metabolism
- Reproductive Medicine
- Endocrinology
- Urology