United Nations
Big Idea: The Time for Divided Nations Is Over
The internet has broken down borders and connected the world, so why do nations still deal with each other through outdated institutions? Oxford professor Ian Goldin, the author of the new book Divided Nations, says there needs to be a radical overhaul of global systems.
What’s your big idea?
For the first time in humanity’s history, citizens around the world share the same information. Since the end of the Cold War in 1990, physical barriers have come down, but so too have virtual barriers. This is great news as the more rapid sharing of ideas and opportunities has been associated with the fastest improvement in life expectancy and rise in incomes in human history. It is also the source of growing threats to the planet and society. One risk is rising inequality, as poor people and poor countries do not have the infrastructure, education or access to modern ideas to benefit from the extraordinary progress of recent decades. The second is cascading and systemic shocks that arise from the pace of change in incomes and technologies and the growing blizzard of complexity associated with hyper-connectivity.
Interdependence is escalating and the failure of the global system to respond is a source of growing instability. Globalization is not being managed. Financial crises, pandemics, cyber attacks, fisheries depletion, climate change, antibiotic resistance and other global threats are the underbelly of globalization. The more connected we are, and the higher our incomes, the more our actions have spill-over impacts on others. Interdependence is the consequence of globalization. This means we urgently need to empower our governments to create more effective national and global institutions.
The sale of a single tuna earlier this year for $1.8 million reflects the free market’s response to growing scarcity of natural resources. Markets alone will not ensure the sustainability of our fragile planet. Rising incomes and population growth mean we need to accept a greater role for regulation and coordinated management at both the national and global level.
While people and systems have become more integrated, global governance systems remain trapped in fragmented and out of date institutional structures that have failed to keep pace with global developments. The multilateral governance system remains largely unreformed and apparently immune to changes in business practice. Our leaders need to focus on the urgent reforms required to manage globalization.
Isn't technology supposed to help facilitate global governance and improve relations between countries?
The financial crisis is the first of the 21st Century Crises but will certainly not be the last. The lessons must urgently be learned. First, we need to recognise that technological and social change are evolving at an accelerated pace, and politicians and regulators need to map and understanding the recent evolution. The internet has provided the nervous system for globalization. The accelerating power of computing processing underlies much of the progress. Yet its ramifications are poorly understood. The potential impact of credit derivatives as weapons of mass financial destruction was not understood, nor was the slicing and dicing of risk across the world in a manner which bore no relation to the primitive national regulatory barriers which the regulators imagined continued to limit exposure. All technologies are dual use. Perhaps the most potent new example is DNA sequencing which will greatly improve all our health care. Yet the exponential decline in the cost means that the threat posed by the fabrication of lethal bio-pathogens is rising. Meanwhile, our dependence on the internet is matched only by our growing vulnerability to cybercrime and other cyber threats which know no national border. Understanding the dual use of technologies and that many of the implications transcend national borders is urgently required.
The multilateral governance system remains largely unreformed and apparently immune to changes in business practice.
What would you like to change about global governance?
The factors that most affect our future, for better or for worse, are likely to require more joined-up thinking both nationally and internationally. Global economic stability and growth, the environment, pandemics, cyber or other opportunities and threats require coordinated responses as none of these can be addressed by any one country alone. Even the most powerful and largest countries—such as the China or the U.S.—will require increased international cooperation.
There needs to be a radical overhaul of global institutions. This is the price of closer integration, rapid population growth and economic growth. Higher incomes lead to greater demand on planetary resources and more interdependence. We cannot rely on the slow melt of the glaciers or their institutional equivalents in the global governance system to accept that we need more global engagement.
Global actions are not a substitute for national action and should be rooted at the community level. It is communities and citizens, and especially the poorest who are always most vulnerable, that suffer the consequences of a global economic crisis, or climate change, or pandemics. There is no trade off between local and global, and an international perspective reflects local needs. Global challenges require global solutions. The time for Divided Nations is over.