Notifying situations of immediate danger
Gasfitters have an obligation to notify the owner/occupier and WorkSafe (Energy Safety) of ‘unsafe’ installations. This article explains a gasfitter’s obligations and how Energy Safety deals with these notifications.
It’s best to start with the regulations which state:
- 10. Obligation to notify WorkSafe of danger
- (1) Any person carrying out gasfitting (including a person acting under an exemption) who has reasonable grounds to believe that any gas installation or gas appliance presents immediate danger to life or property must, as soon as practicable, advise both of the following of the danger:
- (a) the owner or occupier of the property where the danger exists; and
- (b) WorkSafe.
- (1A) The advice in subclause (1) must include—
- (a) details of the nature of the danger; and
- (b) how and why the gas installation or gas appliance presents an immediate danger to life or property; and
- (c) any steps that have been taken, or that the person believes must be taken, to minimise or eliminate the danger.
- (2) A person giving advice under subclause (1)(a) must also advise the owner or occupier to inform the gas retailer or gas wholesaler of the danger.
- (3) A person commits an offence and is liable on conviction to a level 2 penalty if the person has reasonable grounds to believe that any gas installation or gas appliance presents an immediate danger to life or property and the person fails to comply with this regulation.
The obligation to notify (the owner/occupier and then WorkSafe is only when there is an immediate danger to life or property. Immediate danger isn’t defined in the regulations, but can be considered to be when the agent of harm is already present, such as escaping gas or an appliance spilling products of combustion.
A non-compliant installation is not necessarily unsafe, let alone immediately dangerous.
Unsafe is not the direct opposite of safe.
Safe means there is no significant risk of harm or damage.
Unsafe means there is a significant risk of serious harm or significant damage.
There is a spectrum of safety from safe through to unsafe. An installation built to the cited standards is generally considered to be safe. At the other end of the spectrum, regulations 11 through 14(external link) define unsafe situations. If a non-compliant installation does not meet any of the “deemed unsafe” criteria, then it is somewhere in the spectrum between safe and unsafe.
Note that regulation 93 states that despite any current non-compliance, an installation may continue to be used providing it is not now unsafe and was compliant when installed.
A gasfitter has no powers under the regulations to make safe an immediately dangerous situation that he discovers by disabling the appliance or turning off the gas. The gasfitter must seek the permission of the owner or occupier.
Regulation 9(external link) means the owner or occupier has to ensure their installation is safe. An owner or operator commits an offence if they knowingly or recklessly use or allow another person to use an installation if it is unsafe. Regulation 75A(external link) places extra, specific, responsibilities on landlords to ensure their tenanted properties are safe and the occupants have safety instructions.
This is why it is important that the notifying gasfitter provides as much information as possible to the owner or occupier. They more informed the consumer is, the more “knowing” they are and thus the greater is their responsibility and motivation to act.
When reporting an immediate danger to Energy Safety, the gasfitter should supply as much information about the situation as possible. As well as the information specified in subclause 1A above, it is also helpful to supply information on why the gasfitter was there in the first place; specific details of the age of the installation; and what the reaction of the owner or occupier has been.
When informed of an “unsafe” Energy Safety will assess the information and respond accordingly. If it is decided that the installation is unsafe, Energy Safety will contact the owner, advise them of their obligations and request that the situation is made safe within a certain amount of time. If the consumer has not already acted on the advice provided by the gasfitter, they will generally comply once contacted by Energy Safety. If necessary, Energy Safety may ask the gas supplier to cease supply if the immediate danger has not been remedied.
More often than not, the “unsafe” notifications Energy Safety receives are more of a non-compliance nature than a safety matter. In such cases Energy Safety informs the owner of their obligations and the non-compliance discovered. We will advise that while their installation may not be unsafe, they should consider bringing the installation into the current compliance.
Energy Safety occasionally receives an “unsafe” (non-compliant) notification some months after it was first discovered and it appears that Energy Safety was only informed after a consumer did not respond to the original notifying gasfitter’s notification and offer for repair.
When these consumers have been contacted by Energy Safety, they have complained that they felt the gasfitter was applying undue pressure. In such cases Energy Safety will advise the consumer that they have no duty to use the services of the notifying gasfitter and are free to seek a second opinion from another gasfitter.
There is a form on the Energy Safety website for the notification of immediately dangerous installations(external link). If a gasfitter discovers an immediately dangerous installation they can use this form to notify Energy Safety. Before the gasfitter clicks on the “Submit” button to send the data to Energy Safety they can click on the “Generate PDF” button which will create a PDF version of the form which can be sent to the owner. This must be done before the submit button otherwise the data is lost.
A gasfitter may also use this form to generate a PDF form for non-compliances that they can send to installation owners. In these cases they do not need to send it to Energy Safety.