Soon the venerable New York Times will have a new home in the
heart of Manhattan, its first new headquarters office building since the
current one was completed in 1913. The transparent glass tower, 52 stories
high, will overlook the Times Square Redevelopment area on Eighth Avenue
between Fortieth and Forty-first Streets.
Early in 2003, a group of visitors from the New York Times Company and
its design and engineering contractors paid a visit to Berkeley Lab's
Environmental Energy Technologies Division (EETD) to talk about making
buildings energy-efficient, comfortable, and productive places to work.
They spent a day learning about the Lab's research in commercial-buildings
energy efficiency, glazing, daylighting, lighting, and thermal comfort
from EETD's Stephen Selkowitz, Mary Ann Piette, Francis Rubinstein, Eleanor
Lee, and others. As a result of that visit, the New York Times Company
and Berkeley Lab's EETD are beginning a cooperative research project to
test new technologies to increase the energy-efficiency of the new building
and to improve the indoor environment for the comfort of its occupants.
As a major building owner, the Times found it difficult to specify with
confidence a cost-effective, fully integrated glazing (window) and lighting
control system. Berkeley Lab's Building Technologies staff has been researching
these topics for several years with Department of Energy and California
Energy Commission support. The new Times building is an opportunity to
extend and apply Berkeley Lab's prior research, making available more
efficient and cost-effective systems not only to the Times Company but
to other owners and design teams.
The research focuses on integrated technologies to reduce electric lighting
energy use through daylighting, while controlling glare and cooling loads
in this highly glazed building. Researchers are testing alternative hardware
and control solutions in a newly constructed, 4,500 square foot mockup
of a portion of the building.
The research program will not only quantify performance alternatives,
but will provide the New York Times Company with critical performance
information so that it can publish a procurement specification for the
technology solutions for the entire building. The project is being funded
by the New York Times Company and the New York State Energy Research and
Development Authority, with costs shared by the U.S. Department of Energy
and the California Energy Commission.
Pushing the daylighting envelope
"We've known since the 1970s that daylighting can reduce lighting
energy use," says Building Technologies Department Head Stephen Selkowitz.
"But the mere use of large glass areas is not in itself a guarantee
that energy savings or comfort will be achieved, because there are so
many trade-offs involved."
Selkowitz notes that "it's been difficult to make as much progress
in the use of daylighting as we have in other areas of lighting and glazing
technology for a variety of reasons. at all times."
Adds Selkowitz, "The cost of components for successful daylighting
can be high, like dimmable electronic ballasts" which control
fluorescent lights "and the systems with their sensors and controls
require careful calibration after they are installed, something that is
not done very often in buildings today.".
"The project will contribute to Berkeley Lab's longer term energy
efficiency research goals in several ways," says Selkowitz. "Simulation
and field testing will provide a measured database of performance quantifying
the benefits of an optimized solution for this building's design. The
project will include a calibration and commissioning task, which will
help lower costs and improve the operation of the installed systems."
Selkowitz also points to the involvement of numerous manufacturers in
the field test program, which will "directly involve the manufacturers
with the design integration and calibration strategies. And finally, the
very large procurement of an integrated daylighting system based on open,
performance-based specifications should help move the market towards greater
availability and lower costs for these energy-saving building systems."
The building as a contribution to civic life
When the New York Times Company decided to erect a new building, creating
a comfortable working environment for its employees was one of its highest
priorities, along with energy-efficiency. The building was designed to
have transparency, both to bring in the daylight, and to serve as a reminder
of the mission of the newspaper: providing information "transparency"
about the civic life of the nation and the city. To help create a connection
to the community, the building will have an auditorium at the ground floor
for civic and cultural events. The newsroom will occupy floors two through
seven.
An unusual feature of the building, one more common in Europe than in
U.S., will be its fully glazed curtain wall. Thin horizontal ceramic tubes
placed on a steel framework one and a half feet in front of the glass
will screen the double glazed, spectrally selective, low-emissivity, full-height
glass wall around the building, thus reducing the building's cooling loads.
(Low-emissivity glass is an energy-efficient material that helps reduce
heating and cooling use.).
The building will unite most of the 2,500 Manhattan-based employees of
the Times Company, which currently has offices at seven locations in New
York City. "This building is designed from the ground up to reinforce
the values of the New York Times Company," said Michael Golden, vice
chairman of the Times Company, when the plan was announced late in 2002.
"The open plan and ease of communication, both vertically and horizontally,
will enhance collaboration. Our new physical environment will improve
the way we work, which is the highest calling of architecture."
The building was designed by architect Renzo Piano, a winner of the prestigious
Pritzker Prize in 1998, in collaboration with Fox & Fowle Architects.
Construction will start later in 2004, and its expected completion date
is mid-2006.
Piano is well-known for his design of the Centre Georges Pompidou in
Paris, Osaka's Kansai International Airport, and Berlin's Potsdamer
Platz, among many others. Fox & Fowle received a National Honor Award
for Design from the American Institute of Architects in 2000 for their
design of the Condé Nast Building at 4 Times Square, which emphasizes
state-of-the-art energy efficiency and other environmentally responsible
features.
The Energy-Efficient New York Times
Building, part 2