In Tennyson the Victorian poet's sense of a division between the needs of self and of society appears in his quest to find a public use, first, for the kind of poetry that gave him pleasure and, second, for intensely personal experiences, including his reactions to the death of his best friend Hallam, that gave him pain but seemed to have no wider relevance. This quest merges with another project that involves reconciling two contrary poetic modes. The first mode, which "Mariana" (1830) exemplifies, embodies an obvious drive to create intensely visual static panels or tableaux. This poem's seven 12-line stanzas use landscape in the expressionist manner to represent the state of mind of the speaker whom the epigraph identifies as "Mariana of the moated grange" waiting for her lover (from Shakespeare's Measure for Measure). Although time passes as we move from stanza to stanza, nothing happens in the poem, which takes the form of a powerful embodiment of mental depression. Whereas "Mariana" is entirely static, "The Kraken" (1830), whose 15 lines tell of a mythical sea monster's rising to the surface to die at the moment of Apocalypse, takes the form of a kinetic poetry of climax and visionary resolution.
Although in terms of structure and effect these poems appear diametrically opposed, they share a proto-decadent absence of moral or theme. Looking at these two pre-Victorian poems of 1830 (the Queen did not accede to the throne for another seven years), one sees that Tennyson's poetic project involved finding a way to reconcile his opposed poetic modes and at the same time to make them morally and intellectually relevant. He managed to do so two years later in "The Lady of Shalott" and "The Palace of Art", both of which poems take the reader through a series of sharply segmented panels or sections leading to a dramatic moment analogous to one of religious conversion.
In "The Lady of Shalott" Tennyson makes an Arthurian figure of his own invention serve as a symbol for the artist. Isolated within her tower, she weaves a tapestry that depicts human life, which she herself can only experience vicariously and at a distance in a mirror. When the beauty of the passing Lancelot leads her to turn away from her magic mirror and look directly out her window, her mirror and web shatter, flying apart, and her mortality comes upon her. This mythic poem embodies the way ordinary human needs destroy the artist, but in contrast "The Palace of Art", which shares the same climactic structure, makes the contrary point that isolating oneself from society also brings destruction.
Both poems, which present in parabolic form the problematic relation of the artist to society, reflect the political turmoil of the year in which they were written — 1832, the time of the first Reform Bill and the fierce debates about the relation and responsibility of classes. Tennyson, like so many Victorian artists and writers who felt a need to preserve aesthetic distance while making statements about their own age, dramatizes his sense of the artist's problematic relation to his society in mythic, parabolic narratives, which he sets in other places and other times. "The Palace of Art" and "The Lady of Shalott" show Tennyson making a first attempt to find the proper relation of the Victorian author to his audience. They also show that he had solved some of his technical problems by creating a poetic structure that embraced his tendencies toward static and climactic verse and that he had applied the result in creating a morally relevant poetry of vision and conversion.
Throughout his career Tennyson remained interested in momentous changes in a character's consciousness, and his quest for a suitable narrative structure enabled him to discover a form particularly effective in dramatizing religious conversions and analogous moments of revelation. Tennyson's characteristic poetic structure takes the following form: the main character progresses through a series of discrete sections or panels that may take the form of landscapes, states of mind, arguments, or tests until he has a dream, vision, or other powerful revelation that effects a conversion to new ways of life and action. What is perhaps most distinctive about Tennyson's poetic structure is the sharp separation he achieves between sections in many of his poems. In fact, even when telling a story in an apparently straightforward chronological form, Tennyson always prefers to progress through a series of parables, songs, visions, arguments, and actions. His characteristic use of flashbacks, parabolic commentary, and complex plotting creates a narrative form in In Memoriam (1850) and The Idylls of the King (1859-1888) that anticipates the modernist narrative of Faulkner.
Last modified 20 February 2010