For thousands of years, Pacific Islanders have used a variety of traditional practices to effectively manage and sustainably use marine resources. In many cultures there is a long history of setting aside areas for protection of species and habitats (see Table 2 for some examples).
In modern times, the term marine protected area or MPA can mean different things to different people. For some, the term conjures up the image of “no-entry” areas designed to keep people out in favor of protecting nature.
For others it may mean a “no-take” area established to restrict fishing activities. And for still others it may mean a recreation area or park set aside to enhance access to particular activities. Guam’s five locally established marine preserves are types of MPAs, and even these have different regulations associated with each place. So what exactly do we mean, when we refer to MPAs?
In order to provide a common language for people around the world in reference to protected areas, including MPAs, the IUCN World Commission on Protected Areas (WCPA) developed a system of protected area management categories for both terrestrial and marine sites, approved and published in a set of guidelines in 1994. The WCPA definition of a protected area is:
“An area of land and/or sea especially dedicated to the protection and maintenance of biological diversity, and of natural and associated cultural resources, and managed through legal or other effective means.”
According to the IUCN and UNEP / WCMC (2003), there are now more than 100,000 protected areas that have been established for such reasons as protection of species and habitats, watershed protection, promotion of tourism, for recreation, research, education, and as the homelands for indigenous peoples. They vary greatly in size, are given many different names, and have been established by various mechanisms, both legal and traditional. They are owned and managed by governments, communities, NGOs, or combinations of these.
The IUCN Protected Area Management Categories are defined in Table 1.
Table 1. The IUCN Protected Area Management Categories
* Category Ia - Strict nature reserve/wilderness protection area managed mainly for science or wilderness protection – an area of land and/or sea possessing some outstanding or representative ecosystems, geological or physiological features and/or species, available primarily for scientific research and/or environmental monitoring.
* Category 1b - Wilderness area: protected area managed mainly for wilderness protection – large area of unmodified or slightly modified land and/or sea, retaining its natural characteristics and influence, without permanent or significant habitation, which is protected and managed.
* Category III - Natural monument: protected area managed mainly for conservation of specific natural features – area containing specific natural or natural/cultural feature(s) of outstanding or unique value because of their inherent rarity, representativeness or aesthetic qualities or cultural significance.
* Category IV - Habitat/Species Management Area: protected area managed mainly for conservation through management intervention – area of land and/or sea subject to active intervention for management purposes so as to ensure the maintenance of habitats to meet the requirements of specific species.
* Category V - Protected Landscape/Seascape: protected area managed mainly for landscape/seascape conservation or recreation – area of land, with coast resources – area containing predominantly unmodified natural systems, managed to ensure long-term protection and maintenance of biological diversity, while also providing a sustainable flow of natural products and services to meet community needs.
The IUCN categories system was designed for global use. Thus the guidance is broad and general and the system is meant to be interpreted flexibly, allowing regions or countries to interpret them for their own needs and applications.
Recognizing that the future cultural and economic health of the islands of Micronesia depend upon the conservation of marine and terrestrial environments, the Chief Executives of Guam, the Commonwealth of the Northern Mariana Islands, the Federated States of Micronesia, the Marshall Islands and Palau, committed to the effective conservation of at least 30% of the near shore marine resources and at least 20% of the terrestrial resources across Micronesia by 2020. This visionary commitment, the “Micronesia Challenge”, was conceived as a result of the deep commitment of these five leaders to ensure a healthy future for their people, protect their unique island cultures, and sustain the livelihoods of their island communities, by sustaining the island biodiversity of Micronesia.
Guam and each of the other four jurisdictions are designing their own strategies to implement the MC involving partnerships between Government agencies, NGOs and local communities. And each of the five jurisdictions is embracing the broad range of categories of protected areas identified by the IUCN, as well as incorporating additional management activities, to achieve the goals of the Micronesia Challenge.
IUCN (1994); Guidelines for Protected Area Management Categories, IUCN and the World Conservation Monitoring Centre, Gland, Switzerland and Cambridge, UK
IUCN and UNEP/WCMC, (2003) 2003 United Nations List of Protected Areas IUCN and the UNEP/World Conservation Monitoring Centre, Gland, Switzerland and Cambridge, UK
Table 2. Traditional and modern names for protected areas in the region.
Because of differences in purpose, MPAs have many modern and traditional names within the region and throughout the world. Some of these include:
TRADITIONAL NAMES
* Kapu – Hawaii
* Mo –Marshall Islands
* Bul – Palau
* Wasahn Nahk - Pohnpei
MODERN NAMES
Marine Preserve – Guam
Locally Managed Marine Area –Fiji
Marine Life Conservation District – Hawaii
Fisheries Replenishment Area – Hawaii
Sanctuary/Marine Sanctuary – CNMI/American Samoa/Kosrae
Community-based Fisheries Management Reserves – American Samoa
Marine Conservation Area – CNMI
Reprinted from the Pacific Islands MPA Community (PIMPAC) Newsletter V1i1.
Us | Subscribe | Place
an ad
Use of this site indicates your agreement to the
Terms
of Service and Privacy
Policy
(Terms updated March 2007)