A book on the history of the Literary Fund raises broad questions of how our bureaucracy works.
I was too closely involved with Elizabeth Caffin’s The Deepening Stream: A History of the New Zealand Literary Fund to review it. But it contributed to my understanding of some general issues; I think I am allowed to use the book to share them with you.
For the record, the LF was started as a stand-alone entity established in the later 1940s. It lasted until 1988 when it was absorbed into the Queen Elizabeth II Arts Council (later Creative New Zealand) where its ghost struggled on for a few years before it was exorcised. The book argues it had an enormous effect on the development of New Zealand literature, although its funding was small. (About 6 percent of CNZ’s funding today goes on literature.)
While focussing on the literary issues the book also gives an account of the development of public-sector decision-making – albeit in one tiny part of the system. One of my grumbles about our teaching of public policy is that insufficient attention is given to how it actually happens. There are few careful studies; the book adds to them.
Because it is over a five-decade period, the story shows an evolving public policy process. In the beginning one politician, Peter Fraser, then prime minister, drove the introduction of the LF operating through the Under-Secretary for Internal Affairs, Joe Heenan. Of course the times were ripe for the institution – ‘over ripe’ one might say, since the war had delayed the establishment of it (and other cultural institutions such the NZSO).
However his National successor, Sid Holland, had little interest in literature. Had the LF’s establishment been raised on his watch, it would not have happened. This is not to make a political point. It is true that Labour Prime Ministers Fraser, Norman Kirk and Helen Clark contributed greatly to the development of the arts.But so did National ministers Alan Highet, Doug Graham and Chris Finlayson.
As the LF evolved the ministers stepped back and the bureaucrats took over. It was bureaucracy which drove the absorption of the LF into the Arts Council in the late 1980s. They saw it as an anomaly in their ordered system of things; how often have other apparently good arrangements been upset because they did not fit the bureaucrats’ Procrustean bed? However, the cost of administering the small fund may have been a factor; sometimes it may have cost more to run than the amount it gave away.
Did the system lead to political interference? The allegation has been made for other more generously funded state cultural agencies such as the French one. There are number of examples in the book; the most effective way was to appoint the ‘minister’s man’ (or woman) to the committee, although there were also some more direct interventions. It was not always the politicians. Because of his religious views, an early LF secretary, Pat Lawlor, did his best to scupper a grant to a novel by David Ballantyne. The media did its bit too, with a tizzie fit in 1959 over three short stories about ‘seductions’ (by Marilyn Duckworth, Richard Parker and Jacqueline Sturm). Caffin dryly comments, ‘none would cause anyone from a later age the slightest concern.’
The main funder of literary activity in New Zealand is, of course, the private market – the royalties paid to authors. But because New Zealand is small and publishing involves strong economies of scale, subsidies are an important facilitator. There has always been some private patronage – the LF fostered some initiatives – but in recent years a number of foundations and the like have added to the funding of our arts system, much to its benefit. As much as the resulting diversity is to be welcomed, it is the rich who can afford to be patrons. They too may have political agendas and as reluctant to rock the boat. Arguably the state funding agency is more democratic.
Yet it is odd how little engagement New Zealand literature has had with politics/the political economy in the last 30 years. Some years ago I wrote about how often images of Muldoon appeared in our literature, arguing that he represented the nation’s Jungian shadow of authoritarian power. Today neither Clark’s nor Key’s nanny state are dominant themes – perhaps everyone has aspirations for the Prime Minister’s literary prizes.
I am not saying there has been no political works among our recent literature, just that proportionally there are less than in comparable regimes overseas. Nor is this is simply the result of state funding, although the priority on quality writing over content may be a factor.
This problem of making good judgements by state agencies is not confined to literature or the arts. It occurs in natural science, social science, history, and many other facets of New Zealand life. As M. K. Joseph wrote sixty years, ago we have a national tendency to ‘worship the mean, cultivate the mediocre’. Frankly, if we chose the All Black selectors the way we chose some of our assessment panels, the All Blacks would have trouble beating the Te Awamutu second fifteen.
The LF was an exception. There may have been some dullards on its committees, but the chairmen were outstanding and usually there was at least one other committee member of considerable literary acumen. Because it is a ‘venture capital fund’, some of its bets were failures but the returns on other ‘investments’ more than compensated. Sometimes the judgements were inspired. Keri Hume got her first grant having only ever won the Te Awamutu Short Story Competition.
Yet, yet; Ronald Hugh Morrieson, one of our most interesting novelists – all four gothic novels he wrote in his short life have been made into usually successful films – does not appear in the book. I suppose he never applied, but surely he deserved some public or private support.
Ultimately then, for me the book illustrates the development of the government policy system and the challenge of designing one which makes quality judgments. But, to finish on an almost reviewer note, many will read the book for its story about the development of New Zealand literature and some marvellous anecdotes about some of our most beloved and eccentric writers.
- 12080 views
- Print story
- Send to a friend
- Text larger
- Text smaller
I had an interesting conversation about the column with an old literary friend last night, which made me realise that some people may interpret my reference to 'politics' in the narrow context of what goes on in parliament and the beehive. I've made a small change to indicate my concern was the wider political economy. I am greatly puzzled by the current social and political transformation going on, With a few exceptions our literature is not helping me much.
To underline my concern I appreciated Maurice Gee's Crime Story while Charlotte Grimshaw's Soon is grappling with the issue too.
Post new comment