10 good reasons for using jquery as your javascript framework
I'm a jquery lover - I admit. ever since I started using this excellent framework - I got hooked. Since I'm consider myself a core javascript developer, I tend to test and research before I choose to use others work. Well - Jquery has passed the test! Nowadays, when developing in javascript, a developer has to be able to code for all browsers at least (in my opinion and as a proof of concept from our reality). It's one of the most common requirements a javascript project must take into an account when developing any project. The browsers market is changing and people are getting to know few browsers and tend to prefer one over the other. There are many good reasons for why using jquery as your javascript framework.
After working for quite some time with jquery in big and small projects, these are my top reasons:
10 Good Reasons for using Jquery as your Javascript framework
- Easy to use if you have a hidden element (of any kind - li, div, td, etc) - in order to show it, it's "display" property has to set the its proper "block" state. Each element has its own native "block" state. Jquery does that simply with the show() method: $('div').show(). So - if it's a "td" element, in modern browsers (such as firefox, chrome, webkit etc..) this method will set its display property to "table-cell".
- Performance Jquery uses a document fragment for some inner dom processing - which results in faster dom manipulations such as: appending html content, removing elements etc.
- CSS (xpath) selector syntax to retrieve elements one of the most common actions in jquery is to get a set of elements (or one element) and perform one or more actions on it. Jquery uses the sizzle engine to retrieve dom elements. Sizzle uses the convenient simple css syntax to describe the elements it will try to retrieve. i.e., if i want to retrieve all elements with class "my-class", which has a div ancestor: $('div .my-class').
- Easy Ajax Jquery has implemented a very convenient and easy cross-browser ajax. Handling callbacks, passing values as json or other data format is straight forward. Moreover, there are simplified versions of the $.ajax() method for just $.get() for loading a url, $.getJSON() for loading json data and $.post() method for posting data to the server (using POST method).
- Plugin System One is able to extend jquery by plugins. Jquery plugins are usually additional javascript code which is overloaded to the Jquery object, allowing to achieve components, effects and easy tasks like $(element).grid(), $(element).treeview(), $(element).editable() etc. the Jquery website hosts thousands of useful plugins for free use, all categorized by its relevance - you don't need to reinvent the wheel - some of it is already there (if not all) and you can use it, extend it and learn from it.
- Worldwide community support Jquery is being used by many (millions...). Microsoft officially supports this library integrating tools in its developer web tools, the web is full with tutorials, mentors and help using jquery for any project or use.
- Excellent Event Management System jquery has a very convenient event management. you can bind events easily and you get an event object (again, cross-browser) with useful properties. One addition that I like is the ability to have a namespace for any event, i.e.: $('#myId').bind('click.anyObject'). Now, when myId is clicked, it will trigger a click with the additional property of "anyObject" as a namespace. In fact, you can use this namspace again for more objects.
- Dom Manipulation is a breeze Jquery has simple syntax for removing, adding, appending or operating any kind of manipulation on dom elements including attribute manipulation. i.e., for removing an element: $('#myElement').remove(), for deep cloning an element: $('#myElement').clone().
- Getting form element values Again. the elegant way of getting values from any form element is simply as: $('#someFormElement').val(). However, you can also use the form function $('myForm').serialize() to retrieve a query string which includes the form elements with their values ready to be sent with an ajax call.
- Get the source dom element Sometimes, you'll want to use the source dom element resulted in your jquery object,so you can finally revert back and get the reference source dom object easily with: $('.myClass').get(5); (where you can use any index to get any object in the jquery result set).
- BONUS Reason: Method Chaining I couldn't avoid this one: since jquery mostly returns a jquery object, you can write few operations in one line. i.e.: $('.tool-tips').append(' ').addClass('new-tool-tip').bind('click', someFunctionName);
These are some of my 10 good reasons for using jquery. I'm sure there are a lot of other good reasons for using jquery in your projects. It's fast, it's dynamic, it's open source, it's cross-browser and it's beautiful and elegant. I'm sure once you start developing with it, you'll feel very comfortable and you'll get the feeling of where it can assist you and save time while writing elegant code.