Millennials buy more wine online and want it to be organic
Across food and beverage, consumers are demanding transparent supply chains. They want to know what goes into products before they purchase and consume them, and have made a push for more organic and sustainable choices.
It’s a movement led by millennials, who are more likely to adopt ‘healthy’ trends like biodynamic farming and diets like keto and paleo. Young people are also finding more ways to buy their groceries online, shopping for globally-inspired flavors and a roster of healthy food in general
A climate change positive?
This has bled into the wine category in a major way, according to Alan Beasey, Sommelier and Head Bartender at The Purple Pig in Chicago. He told BeverageDaily that restaurant patrons now ask for organic wines ‘all the time.’
“People that come into the restaurant are very interested in making conscious choices about what they’re eating and what they’re drinking. They get excited about knowing where things come from and how things are produced,” he said.
“They lean toward and focus on local produce for food choices. A big category for wine is natural, organic, sustainable production methods.”
Organic wine only accounts for about 3.6% of global wine consumption, but it’s a fast-growing movement. Beasey said it’s important that more winemakers are turning toward organic and biodynamic practices to preserve the vineyards and soils, and also believes that it improves the quality of the wine.
He thinks this shift is born partly from the effects of global warming and climate change, as a lot of old winemakers with centuries of tradition are looking at these changes in weather patterns and climate as an opportunity, more than as a limitation.
France's Domaine de la Romanée-Conti, widely considered to be one of the world’s best wine producers, famously converted to biodynamic farming in all of its vineyards, inspiring other winemakers to take on the complicated and expensive process for getting the most out of their land.
Consumers are responding to this by asking for more label transparency in their alcohol and for options that reflect sustainable and biodynamic practices.
“It pushes the industry to make changes; it pushes us to be more conscious about the wine we’re sourcing and that I’m buying. I look for these things now, and it’s important to me,” Beasey said.
Reviving global wines
An interest in foreign market wines is expected to flourish in 2019, and Beasey reports that even the landlocked midwest is seeing an influx of options beyond classics like France, Italy and Napa Valley.
Germany and Austria are producing more red wines than usual, which require a longer growing season and warmer temperatures. Beasey thinks more “interesting and good quality wines” are coming out of central Europe, like from Georgia and Hungary.
Unfortified, dry wines are being explored by Portugal, which is well-known for Port and other sweet dessert wines. And Lebanon, Armenia, Bulgaria, Croatia and Slovenia are all ramping up their winemaking abilities as well.
“Some of these countries were under the former Soviet umbrella, and they have just now started to get their wine and beverage industries back on track after decades of being held under the thumb of the former Soviet government,” Beasey said.
“It took until now for some of these countries, like Armenia, Georgia and Bulgaria, to revive what was a centuries-old winemaking tradition that never really died, but it was in hibernation for a long time.”
Beasey said that the Fertile Crescent area of Eastern Europe and Western Asia is home to “a great bedrock of winemaking” that is “being re-awoken.”
The dreaded 'wall of wine'
To enjoy these ‘re-awoken’ wine markets, US millennials are turning to the internet. Wine.com sold 38,000 different wines in 2018 from 5,500 wineries, and millennials now make up one-third of the site's shoppers.
Rich Bergsund, CEO of Wine.com, said "Mobile is the best thing to ever happen to wine retailing. It puts the power of wine scores, write-ups, videos and our live chat experts right in the hands of our customers -- helping them discover and enjoy wine with confidence, wherever they are."
Wine.com launched a mobile app in mid-2017 and mobile revenue has since grown to represent 30% of total revenue. Mike Osborn, founder and executive VP of Wine.com, credits the success to young consumers’ disdain for in-person shopping: "Millennials will not put up with the dreaded 'wall of wine' at retail," he said.
With consistent annual growth of 15%-20% over the last few years, Wine.com’s success represents the public’s desire to make it easier to purchase alcohol online. Wine has seen a more complicated path to ecommerce than most other food and beverage products.
Wine.com will start sharing its online wine purchase data with Nielsen to make the channel more transparent, and to “measure, predict and activate on insights to improve performance within the wine category."
Beasey of The Purple Pig finds all the latest shifts in wine consumers' behavior helpful to the restaurant and bar industry, even with the rising popularity of ecommerce.
He said, "It helps make us better when our guests are better informed, and when consumers are more engaged and enthusiastic about trying new things. It motivates us and keeps us always trying to improve and come up with the next thing."
Helping Millennials to find their perfect wine
Posted by René Charles Wyttenbach - inventor of visual.wine,
Report abuse