-Axis2 version 1.0
This document will give you an introduction to the role of Web services policy in Axis2.
E-mail comments/ suggestions to: axis-dev@ws.apache.org. Prefix subject with [Axis2]. To subscribe to mailing list see here.
To consume non trivial web services one must fully understand its xml contract (WSDL) along with any other additional requirements, capabilities or preferences which translates to the configuration of the service, and essentially becomes the policies of the service.
WS Policy framework provides a way to express the policies of a service in a machine-readable way. Web services infrastructure can be enhanced to understand and enforce policies at runtime. For instance, a service author might write a policy requiring digital signature and encryption, while service consumers could use the policy information to reason out whether they can adhere to this policy information to use the service or not.
Further more, web service infrastructure could be enhanced to enforce those requirements without requiring the service author to write even single line of code.
This release fully supports WS Policy at client-side. It means that when you codegen a stub against a WSLD which contains policies, the stub will contain the capability to engage the required modules with the appropriate configurations. For instance, if there is a security policy attached to an operation in the WSDL, the generated stub will engage the security module for that operation with the appropriate security configurations.
Codegen engine runs few of its registered extensions before it generates the stub. When PolicyEvalutor (which is a registered Codegen extension) is initialized, it populates a registry of namespaces of supported policies to PolicyExtensions.
For instance, module foo might have a mapping of namespace which means any primitive assertion which has this namespace will be processed by this module. Foo module might implement the ModulePolicyExtension interface through which PolicyExtension object can be obtained.
A PolicyExtension is the access point for a module to add any other methods to the stub. For instance Reliable Messaging module can add createSequence() and endSequence() methods to the stub, that the user must call to start and end an RM sequence.
Then at the engagement of PolicyEvaluator, effective policy of each operation is calculated based on policy information declared in the WSDL document. Here we assume that effective policy of an operation contains a single alternative (Multiple policy alternatives are not supported). Then we split that policy as follows into few other policies such that, each policy will contain primitive assertions belonging to only one namespace.
<wsp:Policy> <wsp:Policy> <wsp:Policy> <wsp:Policy> <a:Foo/> <a:Foo/> <b:Foo/> <c:Bar/> <a:Bar/> => <a:Bar/> </wsp:Policy> </wsp:Policy> <b:Foo/> </wsp:Policy> <c:Bar/> </wsp:Policy>
Then each policy is given to the appropriate PolicyExtension with an org.w3c.Element type object to which the module can append any other elements/attributes it wishes. Those attributes/elements should resolve to meaningful stub functions via PolicyExtensionTemplate.xsl at latter point of time.
For instance depending on the policy, Security module can append <username>, <passwd> elements to the given element as children, which are later resolved into setUsername(..), setPasswd(..), functions of the stub. This way a module can include additional methods to the stub which can be used to get specific parameters to the module. These methods store any user input in the ServiceClient properties (ServiceClient.getOptions().putProperty(...)) which can later be accessed by the module.
Further, effective policies (based on the WSDL) at appropriate levels (service level, operation level) are stored as policy strings in the stub. Few more generic methods are also added to the stub which are used to evaluate/process policies at runtime.
When a new stub object is created, the policy strings in the stub are converted into policy objects and merged together to get the effective policies of each operation. These effective policies are stored in appropriate AxisOperation objects which a module can access at later point of time.
Then based on its policy each AxisOperation is engaged to a set of modules.
When the stub method is invoked, those modules which are engaged to that AxisOperation, access the effective policy for that operation via AxisOperation object. It can get other information needed from the MessageContext which get stored by stub methods which the module has added to the stub earlier. The modules are required to loads their configurations according to the effective policy which is set in AxisOperation and properties they get via MessageContext.
In this current release Axis2 framework uses WS-Commons/Neethi framework to manipulate policy documents. All its description builders store any policy information included in description documents (services.xml, axis2.xml, .. etc) in the appropriate description classes. This information is available at both deployment and run time via these description classes.
When generating WSDL dynamically for each service, policy information in the description classes is included. For instance, if you declare a policy in axis2.xml then that policy is reflected in service elements of WSDL of every service. If a policy is declared in a services.xml, it is shown in the service element of WSDL for that particular service.
Next step is to use that information to engage and configure required modules and allow the module to make use of this policy information.
It is evident that a great deal of work is required to make axis2 a fully fledged ws-policy supported web service infrastructure. But it is encouraging to note that we've taken the first steps towards this goal. We appreciate any suggestions, patches etc you send us in this regard. Keep on contributing...!