Despite Political Shift in Congress, Employers Insist They Want Health Care Reform
“A year ago, I would have been very hard-pressed to see a way for the [U.S.] Chamber of Commerce not to support health care reform,” said James Gelfand, senior manager for health policy at the chamber. “We had members clamoring to do health care reform. I couldn’t imagine not being supportive. Then we saw the health reform bills.”
The opposition among employers to the health care reform bills passed by the House and Senate late last year helped galvanize national opposition that perhaps culminated Tuesday, January 19, in a surprising Senate victory by a Republican in Massachusetts—a state that knows firsthand the fiscal trouble that results from implementing health care reform without cost controls.
The election of Scott Brown to the Senate seat vacated by the death of Sen. Ted Kennedy, a liberal who called health care reform his life’s work, has upended the health reform process by shattering the Democrats’ filibuster-proof majority.
Democrats now must choose from an array of unpalatable options. They include ramming through a politically toxic health reform bill before Brown is sworn in, giving up on health care reform altogether, or starting again.
The defeat of the bill might give employers what they wished for, but it would be a Pyrrhic victory if efforts to control costs are lost along with the current health reform legislation.
“What we’ve always wished for is a sensible, practical, bipartisan health reform bill,” said Paul Dennett, senior vice president for health policy at the American Benefits Council. “This may be the wake-up call that nudges the legislation in the right direction.”
Democratic leaders have vowed to push on with current health reform legislation, though some Democratic senators have cautioned them to heed the public’s souring support for reform. Much will depend on the leadership provided by President Barack Obama during his State of the Union address next week, analysts say.
“Just as this week all eyes were on Massachusetts, all eyes now are going to be on the president’s address to Congress,” Dennett said.
Majority Leader Harry Reid, D-Nevada, said the Senate wouldn't act on a final health care bill before Brown is sworn in.
"First of all, we're not going to rush into anything," Reid told reporters at a January 20 Capitol Hill press conference.
Employers would like to see a do-over. Already, they are beginning to outline what a new vision of health care reform might look like, focusing on reforms that are widely supported. But the toughest issues persist.
Foremost on their list are measures that would improve the quality of health care and reduce its cost. By and large, those efforts are already under way, though health reform legislation contained funding to expand pilot programs to change the way care is paid for. The legislation would also have established more research into comparing the value of various medical treatments.
Provisions with broad-based support are ones that aim to change the way insurance companies operate. The public and members of Congress widely support changes that would prohibit insurance companies from denying or limiting people’s coverage. But guaranteeing people coverage could lead to “free riders” who buy coverage only after they become sick.
The cure for this policy conundrum has been—as was the case in 2006 when Massachusetts passed its own version of health care reform—to require all individuals to purchase health coverage. It is a policy fraught with consequences, not least of which is forcing people to buy coverage they cannot afford and then offering subsidies that the state or federal government also cannot afford.
All of this underscores why changes in the nation’s health care system never come easy, if they come at all.
The last time Democrats attempted health care reform was 17 years ago. While a complete overhaul was defeated, Dennett points out that piecemeal changes were subsequently made: The HIPAA law protects people with previous health insurance coverage from being denied coverage when they change health plans; a mental health parity act was passed; and in 2003, President George W. Bush signed a prescription drug benefit for seniors.
If health care reform is shot down nationally because of the Massachusetts election, it will be for similar reasons that reform has begun to fail the people of Massachusetts, said Steve Wojcik, vice president of public policy for the National Business Group on Health.
The state changed its insurance laws and required everyone to purchase insurance. In its effort to help people afford insurance, it began to offer subsidies that have since been scaled back because the state did not reduce the cost of health care before expanding coverage.
To expand coverage at the federal level without reducing costs “creates more complexities down the road,” Wojcik said.
“Sooner or later legislators have to deal with the real issue,” Wojcik said. “They need to go face to face with doctors, hospitals and the associations that represent them and say we need to fundamentally revamp the way we pay you guys. Not just Medicaid and Medicare, but the private sector can’t afford this anymore. That’s what they really need to do.”
Stay informed and connected. Get human resources news and HR features via Workforce Management's Twitter feed or RSS feeds for mobile devices and news readers.