The U.S. Forest Service is putting the finishing touches on a massive, 37,500-acre thinning plan all the way from Tonto Creek to Star Valley.
The dramatic thinning of the overgrown forest would protect the most endangered communities in Rim Country — the settlements of Kohl’s Ranch, Christopher Creek and Tonto Village, nestled now in thick forest.
Moreover, thinning the 800 to 1,500 trees per acre down to densities closer to 50 to 80 trees per acre will protect Star Valley and Payson from fires roaring out of the forest to the east, planners said.
The 37,500-acre project area includes roughly 1,100 acres of private land, much of it in about 10 enclaves, all surrounded by thick, overgrown, fire-prone forest. The project area is about 10 miles across and 8 miles wide, with the Control Road and Highway 260 running through the middle of the rugged terrain.
The comment period for the Myrtle Wildland Urban Interface project’s combination of controlled burns and hand thinning closed this week, but it could take a decade of scrimping, saving and lucky grant writing to come up with the millions of dollars needed to complete the project.
The interlocking projects under the Rim and north of Highway 260 will complete the most urgent projects in Rim Country, officials said. In the past five years, the Forest Service has thinned tens of thousands of acres to create fire buffer zones around Pine, Strawberry and Payson.
Tonto National Forest fire planners from the Payson Ranger District will compile input received during the public comment comment period before coming up with the final plan.
The draft plan included some controversial elements.
The plan calls for cutting down almost all white fir, Douglas fir and ponderosa pine less than 18 inches in diameter at chest height.
Forest advocates have often pushed for rules that would spare trees 16 inches in diameter or even 14 inches in diameter, arguing that a healthy forest needs an adequate supply of such large trees. Such large trees typically have their lowest branches beyond the reach of ground fires, which means a forest dominated by such trees would resist fires and even benefit from the periodic, low-intensity ground fires to which the forest is naturally adapted.
However, including the larger trees on which the timber companies that do the thinning can make a profit, can offset the cost of the project.
The proposed rules would also remove all dead pines up to 18 inches in diameter. Several studies have reported large dead snags and even downed logs are the focal point for a majority of the insect and wildlife activity in the deep forest.
The draft rules would remove all live and dead Arizona white oak and Emory oak less than 10 inches in diameter in the project area. In addition, thinning crews would remove all juniper up to 20 inches in diameter and all the brush.
The draft rules would spare all trees above those limits, even if it would result in areas with more than the target 80 trees per acre. In addition, crews would leave smaller trees where necessary to keep densities from falling below about 50 trees per acre.
The rules would spare any pinyon pines as well as any hardwood trees in riparian areas.
Those rules would apply mostly in the 4,447 acres earmarked for hand thinning, mostly areas too close to houses to risk the use of controlled burns. In those areas, crews would use chain saws to thin the forest, pile up the cut trees in massive slash piles, then burn those piles by hand once they’d dried out.
Crews would do less thinning on another 12,000 acres, before setting controlled fires during cool, wet times of the year to burn off the slash and additional underbrush. The partial hand thinning would in theory keep the prescribed fire from climbing up into the remaining trees and getting out of control.
Generally these “thin from below” areas would abut the hand-thinned areas and run along both sides of the highway.
The plan also calls for simply setting fire to about 10,000 acres, after first creating fire breaks and buffer zones to keep the fire contained.
Such “prescribed fire” areas would generally burn on the steepening slopes north of the Control Road, but under the Rim. Crews would use existing fire breaks and Forest Road 300 up on top of the Rim to keep those fires from spreading out of control.
Forest managers hope to use the combination of hand thinning and controlled burns to create a more natural mosaic of shaded forest stretches, meadows, open areas and protected stream sides.
Some research suggests that regular, low-intensity ground fires created just such a ecological patchwork before a century of grazing, logging and fire suppression resulted in a dramatic and dangerous increase in tree densities.
However, preparing an overall plan for such a large area, with a wealth of wildlife, in-holdings and riparian areas, could prove challenging. Endangered species like Mexican Spotted Owls, Mexican Garter Snakes, Chiricahua Leopard Frogs and many others each have sometimes conflicting habitat needs.
However, the Tonto forest has proved adept at completing the master plans for such controlled burns and then snatching federal grants as they become available. Often, the Forest Service comes up with year-end money for thinning projects to protect forest communities, for which only forests that have completed all the preliminary work can compete.
In addition, Tonto National Forest lucked out this year in snagging millions of dollars in federal stimulus grants to thin thousands of acres.
Use the comment form below to begin a discussion about this content.
Requires free registration
Posting comments requires a free account and verification.
Or login with:
OpenID