Laid to rest: Identifying unknown Canadian soldiers who fell in battle in Europe
A
A
Share via Email
OTTAWA — It was a construction crew working on a hospital expansion that first came across human remains in 2010 near the pastoral French town of Vendin-le-Vieil — remains that would later prove to be those of an unknown Canadian soldier.
Over the six years that followed, the remains of 18 more missing Canadians would be found in the same area, either in small groups or alone where they fell nearly a century earlier.
Located outside the city of Lens about 200 kilometres north of Paris, Vendin-le-Vieil was the scene of major fighting between Canadian and German forces in August 1917, during what is known as the Battle of Hill 70.
While largely overshadowed by the earlier fight for Vimy Ridge, Hill 70 was a defining moment for Canada, historians say: It was the first time in the First World War that the Canadian Corps was commanded by a Canadian, Arthur Currie, rather than a British general.
The 19 unknown soldiers are believed to have been among the 2,200 Canadians killed in the 10-day battle — hundreds of whom were lost in the muddy battlefield or buried quickly where they fell and thus have no known grave.
Every year, the remains of some of the nearly 28,000 Canadians who went missing or were left with no known grave during the two world wars are discovered on the old battlefields of Europe.
When that happens, it falls to a small team inside the Department of National Defence to figure out their identities using a combination of history and science. The remains of 22 Canadian and 18 British soldiers have been identified since the program began in earnest about a decade ago.
"At the end of the day, these gentlemen made the ultimate sacrifice for their country," said Sarah Lockyer, National Defence's casualty identification co-ordinator.
"The least we can do is try, as best as we can, to return their identity so they can be buried with their name. And also so we don't forget their sacrifice. We continue to tell their story."
Seven Canadians were found in 2016, Lockyer said, including two near Vendin-le-Vieil.
"The first thing when we get the notice of a find from (the) Commonwealth War Graves Commission is we try and figure out who was there and when," said historian Carl Kletke, DND's heritage outreach officer.
The team then uses any unit identifiers — cap badges and uniforms, as well as personal effects such as rings and bracelets — to close in on the soldier's identity.
Several of the unknown soldiers found on Hill 70 are believed to have been from the 16th Battalion (Canadian Scottish) from Victoria, B.C., Kletke said.
Two of the 19 were found with identity discs, which bear a soldier's name, rank and unit. But they could have been carrying the disc of a dead comrade, he warned: "We can never assume anything."
While Kletke leads the historical analysis to determine who went missing in a particular area, Lockyer works on the science.
The Commonwealth War Graves Commission does not allow the remains of soldiers killed during the two world wars to be repatriated, so any forensic work has to be done in Europe.
A forensic anthropologist, Lockyer travels to the continent a few times a year where she attempts to determine the approximate height and age of the unknown soldier by studying his bones.
The forensic data is then cross-referenced with the list of missing soldiers produced by the historical analysis in the hopes a match, or at least a small number of possible matches, can be found.
Lockyer could not say how many soldiers have been declared unknown over the past 10 years, but the most recent success was still fresh in her memory.
This past September, Pte. Kenneth Donald Duncanson was laid to rest in Belgium with full military honours, exactly 72 years after he was killed near the Leopold Canal during the Second World War.
Representing the family at the ceremony was Judith Thomas, who described the surprise news that her second cousin's remains had been found as a "real gift" after decades of uncertainty surrounding his death.
"It does give closure," Thomas said in a recent interview from her home in Saskatoon. "It's remarkable the work they do to do this. And I think they should keep doing it."
— Follow @leeberthiaume on Twitter